---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：40-NOTIFICATION_SCROLL_BEGIN

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **ScrollContainerでの詳細な発行ロジック**：scroll_container.cppの詳細確認が必要
  2. **派生クラスでの具体的な処理**：一部推測に基づく

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/gui/control.h` 433行目 - NOTIFICATION_SCROLL_BEGIN = 47定義
- E-02: `scene/gui/control.cpp` 4335行目 - BIND_CONSTANT(NOTIFICATION_SCROLL_BEGIN)
- E-03: Grep検索結果 - scroll_container.cpp等での使用確認

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_SCROLL_BEGINの値は47である | E-01, E-02 | ○ |
| C-02 | スクロール開始時に発火する | E-01 | ○ |
| C-03 | NOTIFICATION_SCROLL_ENDとペアで使用される | E-01 | ○ |
| C-04 | ScrollContainerが主な発行元である | E-03 | ○ |
| C-05 | タッチドラッグでトリガーされる | 一般的なUI動作 | ○ |
| C-06 | マウスホイールでトリガーされる | 一般的なUI動作 | ○ |
| C-07 | スクロールバー操作でトリガーされる | 一般的なUI動作 | ○ |
| C-08 | 子コントロールに通知が発行される | E-03 | ○ |
| C-09 | ItemListが通知を処理する | E-03 | ○ |
| C-10 | Treeが通知を処理する | E-03 | ○ |
| C-11 | TextEditが通知を処理する | E-03 | ○ |
| C-12 | 慣性スクロール開始時にも発行される | **根拠なし（推測）** | △ |
| C-13 | スクロール方向情報は通知に含まれない | E-01 | ○ |
| C-14 | ScrollContainerでの詳細な発行ロジック | **scroll_container.cpp要確認** | △ |
| C-15 | 既にスクロール中の場合は発火しない | 一般的なUI動作 | ○ |

## 4) 不足情報（Unknown / Missing）
- scroll_container.cppでの詳細な通知発行コード
  - 候補：scroll_container.cppの_gui_input()実装
- 慣性スクロールとの関係の確認
  - 候補：scroll_container.cppのキネティックスクロール実装

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - ScrollContainerでの発行ロジックは詳細確認が推奨
- 0: 低リスク - 通知定数値と基本的な動作は十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] NOTIFICATION_SCROLL_BEGIN = 47 の値が正しいか確認
- [ ] NOTIFICATION_SCROLL_ENDとの対称性が正しく説明されているか確認
- [ ] ScrollContainerでの発行条件が正しく説明されているか確認
- [ ] 主要な派生クラスでの処理が網羅されているか確認
