---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：41-NOTIFICATION_SCROLL_END

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/gui/control.h` - 431行目: NOTIFICATION_SCROLL_END = 48
- E-02: `scene/gui/control.cpp` - 4336行目: BIND_CONSTANT(NOTIFICATION_SCROLL_END)
- E-03: `scene/gui/scroll_container.cpp` - 90行目: propagate_notification(NOTIFICATION_SCROLL_END)
- E-04: `scene/gui/scroll_container.cpp` - 80-92行目: _stop_scroll_drag()メソッド全体
- E-05: `doc/classes/Control.xml` - 1316-1319行目: NOTIFICATION_SCROLL_END公式ドキュメント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知値は48である | E-01 | ○ |
| C-02 | Control.hの431行目で定義されている | E-01 | ○ |
| C-03 | ScrollContainerの_stop_scroll_drag()で送信される | E-03, E-04 | ○ |
| C-04 | beyond_deadzone == trueの場合のみ送信 | E-04 | ○ |
| C-05 | propagate_notification()で子孫に伝播する | E-03 | ○ |
| C-06 | scroll_endedシグナルと同時に発信される | E-04 | ○ |
| C-07 | NOTIFICATION_SCROLL_BEGIN（47）と対になる | E-01, E-05 | ○ |
| C-08 | タッチイベントでのみ動作する | E-05 | ○ |
| C-09 | マウスホイール/スクロールバーでは送信されない | E-05 | ○ |
| C-10 | Android/iOSで動作する | E-05 | ○ |
| C-11 | タッチエミュレーション設定で動作する | E-05 | ○ |
| C-12 | Control.cppの4336行目でBIND_CONSTANTされている | E-02 | ○ |
| C-13 | 90行目でpropagate_notificationが呼ばれる | E-03 | ○ |
| C-14 | drag_touching変数がリセットされる | E-04 | ○ |
| C-15 | beyond_deadzone変数がfalseにリセットされる | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に対して根拠を確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードまたは公式ドキュメントで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] control.hの431行目でNOTIFICATION_SCROLL_END = 48が定義されていることを確認
- [ ] scroll_container.cppの90行目でpropagate_notificationが呼ばれていることを確認
- [ ] Control.xmlのドキュメント記述が設計書の内容と一致することを確認
