---
generated_at: 2026-01-23 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：43-NOTIFICATION_EXIT_WORLD

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `scene/3d/node_3d.cpp` - 206行目: notification(NOTIFICATION_EXIT_WORLD, true)
- E-02: `scene/3d/node_3d.cpp` - 260-273行目: NOTIFICATION_EXIT_WORLDハンドラ
- E-03: `scene/3d/node_3d.cpp` - 1515行目: BIND_CONSTANT(NOTIFICATION_EXIT_WORLD)
- E-04: `doc/classes/Node3D.xml` - 381-383行目: 公式ドキュメント
- E-05: `scene/3d/visual_instance_3d.cpp` - 107-111行目: NOTIFICATION_EXIT_WORLDのシナリオ解除処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知値は42である | E-04 | ○ |
| C-02 | NOTIFICATION_EXIT_TREEの処理中に送信される | E-01 | ○ |
| C-03 | 206行目でnotificationが呼び出される | E-01 | ○ |
| C-04 | 第2引数にtrueを指定して逆順で送信される | E-01 | ○ |
| C-05 | data.inside_worldがfalseに設定される | E-02 | ○ |
| C-06 | data.viewportがnullptrに設定される | E-02 | ○ |
| C-07 | スクリプトの_exit_world()が呼び出される | E-02 | ○ |
| C-08 | NOTIFICATION_ENTER_WORLD（41）と対になる | E-03, E-04 | ○ |
| C-09 | Node3Dおよび派生クラスが対象 | E-04 | ○ |
| C-10 | VisualInstance3Dでシナリオ解除が行われる | E-05 | ○ |
| C-11 | ERR_MAIN_THREAD_GUARDが使用される | E-02 | ○ |
| C-12 | 1515行目でBIND_CONSTANTされている | E-03 | ○ |
| C-13 | エディタでギズモクリアが行われる | E-02 | ○ |
| C-14 | FTIへのnode_3d_notify_deleteが呼ばれる | E-01 | ○ |
| C-15 | xform_change_listから削除される | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に対して根拠を確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードまたは公式ドキュメントで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] node_3d.cppの206行目でnotification(NOTIFICATION_EXIT_WORLD, true)が呼ばれていることを確認
- [ ] node_3d.cppの260-273行目でEXIT_WORLDハンドラの処理を確認
- [ ] visual_instance_3d.cppの107-111行目でシナリオ解除処理を確認
- [ ] Node3D.xmlのドキュメント記述が設計書の内容と一致することを確認
