---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：44-NOTIFICATION_VISIBILITY_CHANGED (3D)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `scene/3d/node_3d.cpp` - 1083-1103行目: _propagate_visibility_changed()実装
- E-02: `scene/3d/node_3d.cpp` - 1084行目: notification(NOTIFICATION_VISIBILITY_CHANGED)
- E-03: `scene/3d/node_3d.cpp` - 1085行目: emit_signal(visibility_changed)
- E-04: `scene/3d/node_3d.cpp` - 1516行目: BIND_CONSTANT(NOTIFICATION_VISIBILITY_CHANGED)
- E-05: `doc/classes/Node3D.xml` - 385-388行目: 公式ドキュメント
- E-06: `scene/3d/visual_instance_3d.cpp` - 113-115行目: _update_visibility()呼び出し

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知値は43である | E-05 | ○ |
| C-02 | _propagate_visibility_changed()で送信される | E-01, E-02 | ○ |
| C-03 | 1084行目でnotificationが呼び出される | E-02 | ○ |
| C-04 | visibility_changedシグナルも発信される | E-03 | ○ |
| C-05 | 子ノードへ再帰的に伝播する | E-01 | ○ |
| C-06 | Node3Dおよび派生クラスが対象 | E-05 | ○ |
| C-07 | VisualInstance3Dで_update_visibility()が呼ばれる | E-06 | ○ |
| C-08 | エディタでギズモ更新が行われる | E-01 | ○ |
| C-09 | 1516行目でBIND_CONSTANTされている | E-04 | ○ |
| C-10 | visibleプロパティ変更時に送信される | E-01 | ○ |
| C-11 | 親の可視性変更時にも伝播する | E-01 | ○ |
| C-12 | is_visible_in_tree()で状態確認可能 | E-05 | ○ |
| C-13 | CanvasItemの同名通知とは値が異なる | E-05 | ○ |
| C-14 | シグナルハンドラで処理可能 | E-03, E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に対して根拠を確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードまたは公式ドキュメントで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] node_3d.cppの1084行目でnotification(NOTIFICATION_VISIBILITY_CHANGED)が呼ばれていることを確認
- [ ] node_3d.cppの1085行目でemit_signal(visibility_changed)が呼ばれていることを確認
- [ ] 子ノードへの再帰的伝播ロジック（1094-1102行目）を確認
- [ ] Node3D.xmlのドキュメント記述が設計書の内容と一致することを確認
