---
generated_at: 2026-01-23 10:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：45-NOTIFICATION_WM_MOUSE_ENTER

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `scene/main/node.h` - 477行目: NOTIFICATION_WM_MOUSE_ENTER = 1002
- E-02: `scene/main/window.cpp` - 795行目: _propagate_window_notification(this, NOTIFICATION_WM_MOUSE_ENTER)
- E-03: `scene/main/window.cpp` - 785-800行目: _event_callback()のWINDOW_EVENT_MOUSE_ENTER処理
- E-04: `scene/main/window.cpp` - 3135-3141行目: _update_mouse_over()の埋め込みウィンドウ処理
- E-05: `scene/main/window.cpp` - 796-799行目: 状態更新とカーソル復元処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知値は1002である | E-01 | ○ |
| C-02 | 477行目で定義されている | E-01 | ○ |
| C-03 | 795行目で_propagate_window_notificationが呼ばれる | E-02 | ○ |
| C-04 | WINDOW_EVENT_MOUSE_ENTERイベントで送信される | E-03 | ○ |
| C-05 | mouse_in_windowがtrueに設定される | E-05 | ○ |
| C-06 | カーソル形状がCURSOR_ARROWに復元される | E-05 | ○ |
| C-07 | windowmanager_window_overが設定される | E-05 | ○ |
| C-08 | NOTIFICATION_WM_MOUSE_EXIT（1003）と対になる | E-01 | ○ |
| C-09 | 埋め込みウィンドウでも送信される | E-04 | ○ |
| C-10 | 他ウィンドウホバー中は先にEXIT処理 | E-03 | ○ |
| C-11 | DEV_ENABLEDで警告出力 | E-03 | ○ |
| C-12 | ウィンドウ内全ノードに伝播する | E-02 | ○ |
| C-13 | Control.NOTIFICATION_MOUSE_ENTERとは異なる | E-01 | ○ |
| C-14 | _update_mouse_over()で埋め込み処理される | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に対して根拠を確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] node.hの477行目でNOTIFICATION_WM_MOUSE_ENTER = 1002が定義されていることを確認
- [ ] window.cppの795行目で_propagate_window_notificationが呼ばれていることを確認
- [ ] window.cppの3139行目で埋め込みウィンドウ処理を確認
- [ ] 状態更新（mouse_in_window、カーソル復元）が正しく実装されていることを確認
