---
generated_at: 2026-01-23 10:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：46-NOTIFICATION_WM_MOUSE_EXIT

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `scene/main/node.h` - 478行目: NOTIFICATION_WM_MOUSE_EXIT = 1003
- E-02: `scene/main/window.cpp` - 819行目: _propagate_window_notification(this, NOTIFICATION_WM_MOUSE_EXIT)
- E-03: `scene/main/window.cpp` - 801-820行目: _event_callback()のWINDOW_EVENT_MOUSE_EXIT処理
- E-04: `scene/main/window.cpp` - 3159-3165行目: _mouse_leave_viewport()の埋め込みウィンドウ処理
- E-05: `scene/main/window.cpp` - 816-818行目: 状態更新処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知値は1003である | E-01 | ○ |
| C-02 | 478行目で定義されている | E-01 | ○ |
| C-03 | 819行目で_propagate_window_notificationが呼ばれる | E-02 | ○ |
| C-04 | WINDOW_EVENT_MOUSE_EXITイベントで送信される | E-03 | ○ |
| C-05 | mouse_in_windowがfalseに設定される | E-05 | ○ |
| C-06 | _mouse_leave_viewport()が呼ばれる | E-03 | ○ |
| C-07 | windowmanager_window_overがnullptrに設定される | E-05 | ○ |
| C-08 | NOTIFICATION_WM_MOUSE_ENTER（1002）と対になる | E-01 | ○ |
| C-09 | 埋め込みウィンドウでも送信される | E-04 | ○ |
| C-10 | windowmanager_window_over != thisならreturn | E-03 | ○ |
| C-11 | ウィンドウ内全ノードに伝播する | E-02 | ○ |
| C-12 | Control.NOTIFICATION_MOUSE_EXITとは異なる | E-01 | ○ |
| C-13 | _mouse_leave_viewport()で埋め込み処理される | E-04 | ○ |
| C-14 | is_embedded()チェックが行われる | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に対して根拠を確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] node.hの478行目でNOTIFICATION_WM_MOUSE_EXIT = 1003が定義されていることを確認
- [ ] window.cppの819行目で_propagate_window_notificationが呼ばれていることを確認
- [ ] window.cppの3163行目で埋め込みウィンドウ処理を確認
- [ ] 状態更新（mouse_in_window、windowmanager_window_over）が正しく実装されていることを確認
