---
generated_at: 2026-01-23 11:00:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：47-NOTIFICATION_WM_WINDOW_FOCUS_IN

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `scene/main/node.h` - 479行目: NOTIFICATION_WM_WINDOW_FOCUS_IN = 1004
- E-02: `scene/main/window.cpp` - 824行目: _propagate_window_notification(this, NOTIFICATION_WM_WINDOW_FOCUS_IN)
- E-03: `scene/main/window.cpp` - 821-835行目: _event_callback()のWINDOW_EVENT_FOCUS_IN処理
- E-04: `scene/main/window.cpp` - 825行目: emit_signal(focus_entered)
- E-05: `scene/main/window.cpp` - 2070-2076行目: ポップアップ時のFOCUS_OUT送信

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知値は1004である | E-01 | ○ |
| C-02 | 479行目で定義されている | E-01 | ○ |
| C-03 | 824行目で_propagate_window_notificationが呼ばれる | E-02 | ○ |
| C-04 | WINDOW_EVENT_FOCUS_INイベントで送信される | E-03 | ○ |
| C-05 | focusedがtrueに設定される | E-03 | ○ |
| C-06 | focused_windowがthisに設定される | E-03 | ○ |
| C-07 | focus_enteredシグナルが発信される | E-04 | ○ |
| C-08 | NOTIFICATION_WM_WINDOW_FOCUS_OUT（1005）と対になる | E-01 | ○ |
| C-09 | ウィンドウ内全ノードに伝播する | E-02 | ○ |
| C-10 | アクセシビリティ処理が行われる | E-03 | ○ |
| C-11 | exclusive_child処理が含まれる | E-03 | ○ |
| C-12 | ポップアップ表示時に関連処理がある | E-05 | ○ |
| C-13 | focused_windowは静的変数である | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に対して根拠を確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] node.hの479行目でNOTIFICATION_WM_WINDOW_FOCUS_IN = 1004が定義されていることを確認
- [ ] window.cppの824行目で_propagate_window_notificationが呼ばれていることを確認
- [ ] window.cppの825行目でemit_signal(focus_entered)が呼ばれていることを確認
- [ ] 状態更新（focused、focused_window）が正しく実装されていることを確認
