---
generated_at: 2026-01-23 16:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-push_warning

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `core/variant/variant_utility.h` 141行目 - push_warning関数シグネチャ
- E-02: `core/variant/variant_utility.cpp` 1028-1036行目 - push_warning実装
- E-03: `core/variant/variant_utility.cpp` 1029-1032行目 - 引数数チェック
- E-04: `core/variant/variant_utility.cpp` 1034行目 - WARN_PRINT呼び出し
- E-05: `core/error/error_macros.h` 713-714行目 - WARN_PRINTマクロ定義
- E-06: `core/error/error_macros.h` 44行目 - ERR_HANDLER_WARNING列挙値
- E-07: `core/io/logger.h` 52行目 - ERR_WARNING定義
- E-08: `core/io/logger.h` 62行目 - "WARNING"文字列
- E-09: `core/io/logger.h` 76行目 - 5スペースインデント
- E-10: `core/variant/variant_utility.cpp` 1762行目 - FUNCBINDVARARGV(push_warning)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | push_warningは可変長引数を受け取る | E-01, E-02 | ○ |
| C-02 | 引数はjoin_string関数で連結される | E-04 | ○ |
| C-03 | 引数が1つ未満の場合エラーが設定される | E-03 | ○ |
| C-04 | WARN_PRINTマクロが内部で呼び出される | E-04, E-05 | ○ |
| C-05 | ERR_HANDLER_WARNINGタイプが使用される | E-05, E-06 | ○ |
| C-06 | 出力プレフィックスは"WARNING:"である | E-08 | ○ |
| C-07 | インデントは5スペースである | E-09 | ○ |
| C-08 | push_errorとの違いはErrorTypeのみ | E-02, E-05比較 | ○ |
| C-09 | @GlobalScope関数として登録されている | E-10 | ○ |
| C-10 | 警告出力後も実行は継続される | E-02 (returnなし) | ○ |
| C-11 | CallError::CALL_OKが設定される | E-02 (1035行目) | ○ |
| C-12 | Logger::ERR_WARNINGとして処理される | E-07 | ○ |
| C-13 | ErrorHandlerListに通知が伝播する | error_macros.cpp 124-130行目 | ○ |
| C-14 | スクリプトバックトレースが出力される | logger.cpp 75-79行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] push_warningが可変長引数を正しく処理することの確認
- [ ] WARN_PRINTマクロとの同等性の確認
- [ ] 出力プレフィックスが"WARNING:"であることの確認
- [ ] push_errorとの違いがErrorTypeのみであることの確認
