---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：50-NOTIFICATION_WM_GO_BACK_REQUEST

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `scene/main/node.h` - 482行目: NOTIFICATION_WM_GO_BACK_REQUEST = 1007
- E-02: `scene/main/window.cpp` - 854行目: _propagate_window_notification(this, NOTIFICATION_WM_GO_BACK_REQUEST)
- E-03: `scene/main/window.cpp` - 853-856行目: _event_callback()のWINDOW_EVENT_GO_BACK_REQUEST処理
- E-04: `scene/main/window.cpp` - 855行目: emit_signal(SNAME("go_back_requested"))

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知値は1007である | E-01 | ○ |
| C-02 | 482行目で定義されている | E-01 | ○ |
| C-03 | 854行目で_propagate_window_notificationが呼ばれる | E-02 | ○ |
| C-04 | WINDOW_EVENT_GO_BACK_REQUESTイベントで送信される | E-03 | ○ |
| C-05 | go_back_requestedシグナルが発信される | E-04 | ○ |
| C-06 | ウィンドウ内全ノードに伝播する | E-02 | ○ |
| C-07 | Androidのバックボタンで送信される | E-03 | ○ |
| C-08 | デフォルトでquit()が呼ばれる | E-03 | ○ |
| C-09 | NOTIFICATION_WM_CLOSE_REQUEST（1006）と類似 | E-01 | ○ |
| C-10 | MainLoopと同じ値を使用 | E-01 | ○ |
| C-11 | カスタムナビゲーションを実装可能 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に対して根拠を確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] node.hの482行目でNOTIFICATION_WM_GO_BACK_REQUEST = 1007が定義されていることを確認
- [ ] window.cppの854行目で_propagate_window_notificationが呼ばれていることを確認
- [ ] window.cppの855行目でemit_signal("go_back_requested")が呼ばれていることを確認
- [ ] Androidプラットフォームでの動作を確認
