---
generated_at: 2026-01-23 15:45:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：51-NOTIFICATION_WM_SIZE_CHANGED

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **リサイズ中の頻繁な発火に関する注意事項**：ドキュメントには明記されていない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/main/node.h` 483行目 - NOTIFICATION_WM_SIZE_CHANGED = 1008 の定義
- E-02: `scene/main/window.cpp` 1339行目 - notification(NOTIFICATION_WM_SIZE_CHANGED) の呼び出し
- E-03: `doc/classes/Node.xml` 1263-1266行目 - 公式ドキュメントの説明
- E-04: `scene/main/window.cpp` 857-860行目 - WINDOW_EVENT_DPI_CHANGEハンドラ（関連コード）
- E-05: `scene/gui/dialogs.cpp` - ダイアログでのサイズ変更通知処理
- E-06: `scene/gui/popup.cpp` - ポップアップでのサイズ変更通知処理
- E-07: `scene/gui/popup_menu.cpp` - ポップアップメニューでのサイズ変更通知処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知値は1008である | E-01 | ○ |
| C-02 | ウィンドウサイズ変更時に発火する | E-02, E-03 | ○ |
| C-03 | Windowノード自身のみが受信する | E-03 | ○ |
| C-04 | 子ノードへの伝播は行われない | E-03 | ○ |
| C-05 | _update_viewport_size()完了後に発火する | E-02 | ○ |
| C-06 | 同期方式で送信される | E-02 | ○ |
| C-07 | scene/main/node.hで定義されている | E-01 | ○ |
| C-08 | DisplayServerからのイベントで発火する | E-02 | ○ |
| C-09 | デスクトッププラットフォームで実装 | E-03 | ○ |
| C-10 | ダイアログ・ポップアップでも使用される | E-05, E-06, E-07 | ○ |
| C-11 | ビューポートサイズ更新処理と連動する | E-02 | ○ |
| C-12 | リサイズ中は頻繁に発火する可能性がある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-12の根拠：OSのウィンドウリサイズ挙動に依存するため、ソースコード上の明示的な記述がない
  - 候補：プラットフォーム固有のDisplayServer実装 / OS動作仕様書 / 実行時テスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 通知値と基本的な発火条件は明確に確認済み
- 1: 中リスク - 頻繁発火時のパフォーマンス注意事項は推測に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] NOTIFICATION_WM_SIZE_CHANGED = 1008 の値が正しいことを確認
- [ ] 子ノードへ伝播しないことを実機で確認
- [ ] リサイズ中の発火頻度を実機で確認
- [ ] ダイアログ・ポップアップでの動作を確認
