---
generated_at: 2026-01-23 15:47:00
metrics:
  claims_total: 11
  claims_with_evidence: 10
  claims_without_evidence: 1
confidence_derived: 0.91
---

# 根拠レポート：52-NOTIFICATION_WM_DPI_CHANGE

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：10 / 11、根拠なし：1
- 優先レビュー（高）
  1. **デフォルトDPI値96の使用**：ソースコードでの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/main/node.h` 484行目 - NOTIFICATION_WM_DPI_CHANGE = 1009 の定義
- E-02: `scene/main/window.cpp` 857-860行目 - WINDOW_EVENT_DPI_CHANGEハンドラの実装
- E-03: `doc/classes/Node.xml` 1267-1269行目 - 公式ドキュメントの説明（macOSのみ実装）
- E-04: `scene/main/window.cpp` 858行目 - _update_viewport_size()の呼び出し
- E-05: `scene/main/window.cpp` 859行目 - _propagate_window_notification()の呼び出し
- E-06: `scene/main/window.cpp` 860行目 - dpi_changedシグナルの発火

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知値は1009である | E-01 | ○ |
| C-02 | DPIスケール変更時に発火する | E-02, E-03 | ○ |
| C-03 | macOSプラットフォームでのみ実装 | E-03 | ○ |
| C-04 | _propagate_window_notificationで子ノードに伝播する | E-05 | ○ |
| C-05 | _update_viewport_size()も同時に呼び出される | E-04 | ○ |
| C-06 | dpi_changedシグナルも発火される | E-06 | ○ |
| C-07 | scene/main/node.hで定義されている | E-01 | ○ |
| C-08 | WINDOW_EVENT_DPI_CHANGEイベントで発火する | E-02 | ○ |
| C-09 | 同期方式で送信される | E-02 | ○ |
| C-10 | ビューポートサイズ更新と連動する | E-04 | ○ |
| C-11 | DPI取得失敗時にデフォルト値96を使用 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-11の根拠：エラーハンドリング時のデフォルト値についてはDisplayServer実装の確認が必要
  - 候補：DisplayServer各プラットフォーム実装 / OS API仕様書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 通知値と基本的な発火条件は明確に確認済み
- 0: 低リスク - macOS限定の実装であることが公式ドキュメントで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] NOTIFICATION_WM_DPI_CHANGE = 1009 の値が正しいことを確認
- [ ] macOSでの動作を実機で確認
- [ ] 子ノードへの通知伝播を確認
- [ ] dpi_changedシグナルとの連動を確認
