---
generated_at: 2026-01-23 15:50:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：53-NOTIFICATION_OS_MEMORY_WARNING

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **Androidでの具体的な実装詳細**：onLowMemoryハンドラの詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/os/main_loop.h` 50行目 - NOTIFICATION_OS_MEMORY_WARNING = 2009 の定義
- E-02: `scene/main/node.h` 489行目 - Nodeクラスでの再定義
- E-03: `scene/main/scene_tree.cpp` 911-920行目 - 通知伝播処理
- E-04: `doc/classes/MainLoop.xml` 107-109行目 - 公式ドキュメント（iOS固有と記載）
- E-05: `drivers/apple_embedded/app_delegate_service.mm` - iOS側メモリ警告ハンドラ
- E-06: `core/os/main_loop.cpp` 34行目 - BIND_CONSTANT定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知値は2009である | E-01, E-02 | ○ |
| C-02 | OSからのメモリ警告で発火する | E-04 | ○ |
| C-03 | iOSで実装されている | E-04, E-05 | ○ |
| C-04 | Androidでも実装されている | E-03 | ○ |
| C-05 | propagate_notificationで全ノードに伝播する | E-03 | ○ |
| C-06 | core/os/main_loop.hで定義されている | E-01 | ○ |
| C-07 | Nodeクラスで再定義されている | E-02 | ○ |
| C-08 | SceneTreeの_notificationで処理される | E-03 | ○ |
| C-09 | ルートノードから伝播が開始される | E-03 | ○ |
| C-10 | 同期方式で送信される | E-03 | ○ |
| C-11 | キャッシュクリアなどの対応が期待される | E-04 | ○ |
| C-12 | AndroidのonLowMemoryハンドラ詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-12の根拠：Androidプラットフォーム固有の実装詳細
  - 候補：`platform/android/java_godot_lib_jni.cpp` / Android側Javaコード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 通知値と基本的な発火条件は明確に確認済み
- 1: 中リスク - Androidプラットフォームでの動作確認が推奨

## 6) レビュアーチェックリスト（最小）
- [ ] NOTIFICATION_OS_MEMORY_WARNING = 2009 の値が正しいことを確認
- [ ] iOSでのメモリ警告動作を実機で確認
- [ ] Androidでのメモリ警告動作を実機で確認
- [ ] 全ノードへの通知伝播を確認
