---
generated_at: 2026-01-23 15:56:00
metrics:
  claims_total: 11
  claims_with_evidence: 10
  claims_without_evidence: 1
confidence_derived: 0.91
---

# 根拠レポート：55-NOTIFICATION_WM_ABOUT

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：10 / 11、根拠なし：1
- 優先レビュー（高）
  1. **Dockアイコンクリック時の発火**：具体的な実装確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/os/main_loop.h` 52行目 - NOTIFICATION_WM_ABOUT = 2011 の定義
- E-02: `scene/main/node.h` 491行目 - Nodeクラスでの再定義
- E-03: `scene/main/scene_tree.cpp` 913行目 - 通知伝播処理
- E-04: `doc/classes/MainLoop.xml` 114-117行目 - 公式ドキュメント（macOS固有と記載）
- E-05: `platform/macos/godot_application_delegate.mm` - macOSアプリケーションデリゲート
- E-06: `editor/editor_node.cpp` - エディタでの使用例
- E-07: `editor/project_manager/project_manager.cpp` - プロジェクトマネージャーでの使用例

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知値は2011である | E-01, E-02 | ○ |
| C-02 | macOSプラットフォームでのみ実装 | E-04 | ○ |
| C-03 | About情報要求時に発火する | E-04, E-05 | ○ |
| C-04 | propagate_notificationで全ノードに伝播する | E-03 | ○ |
| C-05 | core/os/main_loop.hで定義されている | E-01 | ○ |
| C-06 | Nodeクラスで再定義されている | E-02 | ○ |
| C-07 | SceneTreeの_notificationで処理される | E-03 | ○ |
| C-08 | Godotエディタで使用されている | E-06 | ○ |
| C-09 | プロジェクトマネージャーで使用されている | E-07 | ○ |
| C-10 | 同期方式で送信される | E-03 | ○ |
| C-11 | Dockアイコンクリック時に発火する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-11の根拠：Dockアイコンクリック時のapplicationShouldHandleReopen実装の詳細確認
  - 候補：`platform/macos/godot_application_delegate.mm` の詳細分析

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 通知値と基本的な発火条件は明確に確認済み
- 0: 低リスク - macOS限定の実装であることが公式ドキュメントで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] NOTIFICATION_WM_ABOUT = 2011 の値が正しいことを確認
- [ ] macOSでのAboutメニュー選択時の動作を実機で確認
- [ ] エディタでのAboutダイアログ表示を確認
- [ ] Dockアイコンクリック時の動作を確認
