---
generated_at: 2026-01-23 16:02:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：57-NOTIFICATION_OS_IME_UPDATE

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **各プラットフォームでのIME挙動の差異**：詳細な動作確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/os/main_loop.h` 54行目 - NOTIFICATION_OS_IME_UPDATE = 2013 の定義
- E-02: `scene/main/node.h` 493行目 - Nodeクラスでの再定義
- E-03: `scene/main/scene_tree.cpp` 912行目 - 通知伝播処理
- E-04: `doc/classes/MainLoop.xml` 122-125行目 - 公式ドキュメント
- E-05: `platform/windows/display_server_windows.cpp` - Windows IME実装
- E-06: `platform/macos/display_server_macos.mm` - macOS IME実装
- E-07: `platform/linuxbsd/x11/display_server_x11.cpp` - X11 IME実装
- E-08: `platform/linuxbsd/wayland/display_server_wayland.cpp` - Wayland IME実装
- E-09: `platform/web/display_server_web.cpp` - Web IME実装
- E-10: `scene/gui/line_edit.cpp` - LineEditでのIME処理
- E-11: `scene/gui/text_edit.cpp` - TextEditでのIME処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知値は2013である | E-01, E-02 | ○ |
| C-02 | IME入力更新時に発火する | E-04 | ○ |
| C-03 | デスクトップとWebプラットフォームで実装 | E-04, E-05, E-06, E-07, E-08, E-09 | ○ |
| C-04 | propagate_notificationで全ノードに伝播する | E-03 | ○ |
| C-05 | core/os/main_loop.hで定義されている | E-01 | ○ |
| C-06 | Nodeクラスで再定義されている | E-02 | ○ |
| C-07 | SceneTreeの_notificationで処理される | E-03 | ○ |
| C-08 | LineEditがIME通知を処理する | E-10 | ○ |
| C-09 | TextEditがIME通知を処理する | E-11 | ○ |
| C-10 | Windows IME実装が存在する | E-05 | ○ |
| C-11 | macOS IME実装が存在する | E-06 | ○ |
| C-12 | 同期方式で送信される | E-03 | ○ |
| C-13 | プラットフォーム間でIME挙動が異なる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-13の根拠：プラットフォーム間のIME挙動差異の詳細な比較
  - 候補：各プラットフォームの実装詳細比較 / 実機テスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 通知値と基本的な発火条件は明確に確認済み
- 1: 中リスク - CJK言語でのIME動作テストが推奨

## 6) レビュアーチェックリスト（最小）
- [ ] NOTIFICATION_OS_IME_UPDATE = 2013 の値が正しいことを確認
- [ ] 日本語IMEでのLineEdit動作を確認
- [ ] 日本語IMEでのTextEdit動作を確認
- [ ] 各プラットフォームでのIME動作差異を確認
