---
generated_at: 2026-01-23 16:08:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：59-NOTIFICATION_APPLICATION_PAUSED

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **タイムアウト時のOSによる強制終了動作**：iOS実機での確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/os/main_loop.h` 56行目 - NOTIFICATION_APPLICATION_PAUSED = 2015 の定義
- E-02: `scene/main/node.h` 495行目 - Nodeクラスでの再定義
- E-03: `scene/main/scene_tree.cpp` 916行目 - 通知伝播処理
- E-04: `doc/classes/MainLoop.xml` 130-134行目 - 公式ドキュメント（5秒制限記載）
- E-05: `platform/android/java_godot_lib_jni.cpp` - Android JNI実装
- E-06: `drivers/apple_embedded/os_apple_embedded.mm` - iOS固有実装
- E-07: `core/extension/godot_instance.cpp` - GDExtension連携

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知値は2015である | E-01, E-02 | ○ |
| C-02 | アプリがバックグラウンドに移行時に発火する | E-04 | ○ |
| C-03 | AndroidおよびiOSプラットフォームで実装 | E-04, E-05, E-06 | ○ |
| C-04 | propagate_notificationで全ノードに伝播する | E-03 | ○ |
| C-05 | core/os/main_loop.hで定義されている | E-01 | ○ |
| C-06 | Nodeクラスで再定義されている | E-02 | ○ |
| C-07 | SceneTreeの_notificationで処理される | E-03 | ○ |
| C-08 | Android JNI経由で発火する | E-05 | ○ |
| C-09 | iOS AppDelegate経由で発火する | E-06 | ○ |
| C-10 | GDExtension経由でも発火する | E-07 | ○ |
| C-11 | iOSでは約5秒の時間制限がある | E-04 | ○ |
| C-12 | 同期方式で送信される | E-03 | ○ |
| C-13 | タイムアウト時にOSがアプリを強制終了する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-13の根拠：iOS固有のタイムアウト動作の詳細確認
  - 候補：iOS実機テスト / Apple Developer Documentation

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - iOSの5秒制限を超過した場合の動作確認が必要
- 0: 低リスク - 通知値と基本的な発火条件は明確に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] NOTIFICATION_APPLICATION_PAUSED = 2015 の値が正しいことを確認
- [ ] Androidでのアプリ一時停止時の動作を実機で確認
- [ ] iOSでのアプリ一時停止時の動作を実機で確認
- [ ] iOSでの5秒タイムアウト動作を確認
- [ ] NOTIFICATION_APPLICATION_RESUMEDとの連携を確認
