---
generated_at: 2026-01-23 16:11:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：60-NOTIFICATION_APPLICATION_FOCUS_IN

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **連続した同一通知の抑止ロジック**：実装詳細の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/os/main_loop.h` 57行目 - NOTIFICATION_APPLICATION_FOCUS_IN = 2016 の定義
- E-02: `scene/main/node.h` 496行目 - Nodeクラスでの再定義
- E-03: `scene/main/scene_tree.cpp` 917行目 - 通知伝播処理
- E-04: `doc/classes/MainLoop.xml` 135-138行目 - 公式ドキュメント
- E-05: `platform/windows/display_server_windows.cpp` - Windows フォーカス処理
- E-06: `platform/linuxbsd/x11/display_server_x11.cpp` - X11 フォーカス処理
- E-07: `platform/linuxbsd/wayland/display_server_wayland.cpp` - Wayland フォーカス処理
- E-08: `platform/macos/godot_application_delegate.mm` - macOS フォーカス処理
- E-09: `platform/android/os_android.cpp` - Android フォーカス処理
- E-10: `core/extension/godot_instance.cpp` - GDExtension連携
- E-11: `editor/run/embedded_process.cpp` - エディタ埋め込みプロセス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知値は2016である | E-01, E-02 | ○ |
| C-02 | アプリがフォーカスを取得時に発火する | E-04 | ○ |
| C-03 | デスクトップおよびモバイルで実装 | E-04, E-05, E-06, E-07, E-08, E-09 | ○ |
| C-04 | propagate_notificationで全ノードに伝播する | E-03 | ○ |
| C-05 | core/os/main_loop.hで定義されている | E-01 | ○ |
| C-06 | Nodeクラスで再定義されている | E-02 | ○ |
| C-07 | SceneTreeの_notificationで処理される | E-03 | ○ |
| C-08 | Windows DisplayServer経由で発火する | E-05 | ○ |
| C-09 | X11 DisplayServer経由で発火する | E-06 | ○ |
| C-10 | Wayland DisplayServer経由で発火する | E-07 | ○ |
| C-11 | macOS ApplicationDelegate経由で発火する | E-08 | ○ |
| C-12 | GDExtension経由でも発火する | E-10 | ○ |
| C-13 | 同期方式で送信される | E-03 | ○ |
| C-14 | 連続した同一通知が抑止される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14の根拠：連続フォーカスイベントの抑止ロジック実装
  - 候補：各DisplayServer実装の詳細分析

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 通知値と基本的な発火条件は明確に確認済み
- 0: 低リスク - 主要プラットフォームでの実装が確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] NOTIFICATION_APPLICATION_FOCUS_IN = 2016 の値が正しいことを確認
- [ ] 各デスクトッププラットフォームでのフォーカス取得動作を確認
- [ ] モバイルプラットフォームでのフォーカス取得動作を確認
- [ ] NOTIFICATION_APPLICATION_FOCUS_OUTとの連携を確認
- [ ] NOTIFICATION_WM_WINDOW_FOCUS_INとの違いを確認
