---
generated_at: 2026-01-23 15:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：61-NOTIFICATION_APPLICATION_FOCUS_OUT

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **モバイルプラットフォームでのAPPLICATION_PAUSED併用**：具体的な実装コードの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `core/os/main_loop.h` 48-60行目 - NOTIFICATION_APPLICATION_FOCUS_OUT定数定義
- E-02: `core/os/main_loop.cpp` 33-43行目 - BIND_CONSTANT定義
- E-03: `scene/main/node.h` 496-498行目 - Node側での定数継承定義
- E-04: `scene/main/node.cpp` 60-315行目 - _notification処理
- E-05: `platform/windows/display_server_windows.cpp` - Windowsフォーカス喪失処理
- E-06: `platform/macos/godot_application_delegate.mm` - macOSフォーカス喪失処理
- E-07: `scene/main/scene_tree.cpp` - SceneTree通知処理
- E-08: `doc/classes/MainLoop.xml` - 公式ドキュメント定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知値は2017である | E-01 (main_loop.h:58) | ○ |
| C-02 | MainLoopとNodeの両方で定義されている | E-01, E-03 | ○ |
| C-03 | アプリケーションがフォーカスを失った時に送信される | E-01, E-08 | ○ |
| C-04 | propagate_notificationで子ノードに伝播される | E-04, E-07 | ○ |
| C-05 | 同期的に送信される | E-04 (notification処理) | ○ |
| C-06 | NOTIFICATION_APPLICATION_FOCUS_IN（2016）が対となる通知 | E-01 (main_loop.h:57) | ○ |
| C-07 | DisplayServerがOS固有のイベントを検知して発火 | E-05, E-06 | ○ |
| C-08 | WindowsではWM_KILLFOCUSに対応 | E-05 | ○ |
| C-09 | macOSではapplicationDidResignActiveに対応 | E-06 | ○ |
| C-10 | 通知に追加パラメータは含まれない | E-01, E-04 | ○ |
| C-11 | BIND_CONSTANTでスクリプトに公開されている | E-02 (main_loop.cpp:42) | ○ |
| C-12 | MainLoopが設定されていない場合は送信されない | E-04 (条件チェックロジック) | ○ |
| C-13 | エディタ実行中もこの通知は発生する | E-05, E-06 (エディタ固有の除外なし) | ○ |
| C-14 | 外部からの直接送信は不可能 | E-04 (内部通知システム設計) | ○ |
| C-15 | モバイルプラットフォームではAPPLICATION_PAUSEDと併用されることが多い | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- モバイルプラットフォーム（Android/iOS）での具体的な併用パターンの実装コード確認が不足
  - 候補：`platform/android/os_android.cpp` / `drivers/apple_embedded/os_apple_embedded.mm`

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 通知定数の定義と基本的な動作は明確に確認済み
- 0: 低リスク - プラットフォーム固有実装の存在は確認済み
- 1: 中リスク - モバイルプラットフォームでの動作詳細は追加確認推奨

## 6) レビュアーチェックリスト（最小）

- [ ] 通知値2017がmain_loop.hで正しく定義されていることを確認
- [ ] Nodeクラスへの継承定義がnode.hにあることを確認
- [ ] モバイルプラットフォームでの動作を必要に応じて確認
