---
generated_at: 2026-01-23 15:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：62-NOTIFICATION_TEXT_SERVER_CHANGED

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `core/os/main_loop.h` 59行目 - NOTIFICATION_TEXT_SERVER_CHANGED定数定義（2018）
- E-02: `core/os/main_loop.cpp` 43行目 - BIND_CONSTANT定義
- E-03: `scene/main/node.h` 498行目 - Node側での定数継承定義
- E-04: `servers/text/text_server.cpp` 130-142行目 - set_primary_interface実装
- E-05: `servers/text/text_server.cpp` 138-139行目 - MainLoop::notification呼び出し
- E-06: `doc/classes/MainLoop.xml` - 公式ドキュメント定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知値は2018である | E-01 (main_loop.h:59) | ○ |
| C-02 | MainLoopとNodeの両方で定義されている | E-01, E-03 | ○ |
| C-03 | TextServerManager::set_primary_interface()で送信される | E-04, E-05 | ○ |
| C-04 | MainLoopが存在する場合のみ通知を送信 | E-05 (条件分岐) | ○ |
| C-05 | 同期的に送信される | E-05 (notification直接呼び出し) | ○ |
| C-06 | 通知に追加パラメータは含まれない | E-01, E-05 | ○ |
| C-07 | BIND_CONSTANTでスクリプトに公開されている | E-02 (main_loop.cpp:43) | ○ |
| C-08 | プライマリテキストサーバー変更時に発火 | E-04 (set_primary_interface実装) | ○ |
| C-09 | nullが設定された場合はクリアのみで通知なし | E-04 (130-142行目の条件分岐) | ○ |
| C-10 | TextServerAdvancedとTextServerFallbackが主なバックエンド | E-06 (公式ドキュメント) | ○ |
| C-11 | print_verboseでログ出力される | E-04 (136行目) | ○ |
| C-12 | ICU/HarfBuzzはTextServerAdvancedで使用 | E-06 (公式ドキュメント) | ○ |
| C-13 | 外部からの直接送信は不可能 | E-04, E-05 (内部API) | ○ |
| C-14 | SceneTree経由で全ノードに伝播される | E-03, E-04 | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張に明確な根拠あり
- 0: 低リスク - 通知発火ロジックがソースコードで確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] 通知値2018がmain_loop.hで正しく定義されていることを確認
- [ ] text_server.cppのset_primary_interface()で通知が発火することを確認
- [ ] Nodeクラスへの継承定義がnode.hにあることを確認
