---
generated_at: 2026-01-23 15:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：63-peer_connected

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `scene/main/multiplayer_peer.cpp` 124行目 - ADD_SIGNALによるpeer_connectedシグナル定義
- E-02: `scene/main/multiplayer_peer.cpp` 125行目 - peer_disconnectedシグナル定義
- E-03: `scene/main/multiplayer_peer.cpp` 35-55行目 - generate_unique_id実装
- E-04: `scene/main/multiplayer_peer.cpp` 73-79行目 - refuse_new_connections関連メソッド
- E-05: `modules/enet/enet_multiplayer_peer.cpp` - ENet実装
- E-06: `modules/websocket/websocket_multiplayer_peer.cpp` - WebSocket実装
- E-07: `modules/webrtc/webrtc_multiplayer_peer.cpp` - WebRTC実装
- E-08: `doc/classes/MultiplayerPeer.xml` - 公式ドキュメント

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | peer_connectedシグナルはMultiplayerPeerで定義されている | E-01 | ○ |
| C-02 | パラメータとしてint型のidが渡される | E-01 (PropertyInfo(Variant::INT, "id")) | ○ |
| C-03 | peer_disconnectedが対となるシグナルである | E-02 | ○ |
| C-04 | generate_unique_idでピアIDが生成される | E-03 | ○ |
| C-05 | ピアIDは予測困難な値として生成される | E-03 (hash_murmur3使用) | ○ |
| C-06 | refuse_new_connectionsで新規接続を拒否できる | E-04 | ○ |
| C-07 | ENet実装でpeer_connectedが発火される | E-05 | ○ |
| C-08 | WebSocket実装でpeer_connectedが発火される | E-06 | ○ |
| C-09 | WebRTC実装でpeer_connectedが発火される | E-07 | ○ |
| C-10 | サーバーのピアIDは常に1である | E-08 (TARGET_PEER_SERVER定義) | ○ |
| C-11 | シグナルはemit_signalで発火される | E-05, E-06, E-07 | ○ |
| C-12 | 接続ハンドシェイク完了後に発火される | E-05, E-06, E-07 | ○ |
| C-13 | 非同期（シグナル）方式である | E-01 (Godotシグナルシステム) | ○ |
| C-14 | 同一のシグナルインターフェースを各実装で提供 | E-05, E-06, E-07 | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張に明確な根拠あり
- 0: 低リスク - シグナル定義がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] peer_connectedシグナルがmultiplayer_peer.cppで定義されていることを確認
- [ ] パラメータがint型のidであることを確認
- [ ] 各プロトコル実装（ENet/WebSocket/WebRTC）でシグナルが発火されることを確認
