---
generated_at: 2026-01-23 16:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：65-NOTIFICATION_PRE_SORT_CHILDREN

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `scene/gui/container.h` 63-66行目 - NOTIFICATION_PRE_SORT_CHILDREN定数定義（50）
- E-02: `scene/gui/container.h` 38行目 - pending_sortフラグ定義
- E-03: `scene/gui/container.cpp` 81-93行目 - _sort_children()メソッド実装
- E-04: `scene/gui/container.cpp` 87行目 - notification(NOTIFICATION_PRE_SORT_CHILDREN)呼び出し
- E-05: `scene/gui/container.cpp` 88行目 - emit_signal(pre_sort_children)呼び出し
- E-06: `scene/gui/container.cpp` 130-141行目 - queue_sort()メソッド実装
- E-07: `scene/gui/container.cpp` 139行目 - call_deferredによる遅延実行
- E-08: `scene/gui/container.cpp` 224行目 - BIND_CONSTANT定義
- E-09: `scene/gui/container.cpp` 227行目 - pre_sort_childrenシグナル定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知値は50である | E-01 (container.h:64) | ○ |
| C-02 | Containerクラスで定義されている | E-01 | ○ |
| C-03 | _sort_children内でSORT_CHILDRENの直前に送信される | E-03, E-04 | ○ |
| C-04 | pre_sort_childrenシグナルも同時に発火される | E-05 | ○ |
| C-05 | queue_sortでソートがスケジュールされる | E-06 | ○ |
| C-06 | call_deferredで遅延実行される | E-07 | ○ |
| C-07 | pending_sortフラグで多重実行を防止 | E-02, E-06 | ○ |
| C-08 | ツリー外の場合は処理がスキップされる | E-03 (82-85行目) | ○ |
| C-09 | NOTIFICATION_SORT_CHILDRENが対となる通知 | E-01 (65行目) | ○ |
| C-10 | 同期的に送信される | E-04 (notification直接呼び出し) | ○ |
| C-11 | BIND_CONSTANTでスクリプトに公開されている | E-08 | ○ |
| C-12 | NOTIFICATION_RESIZEDでqueue_sortが呼ばれる | E-03 (185-197行目) | ○ |
| C-13 | NOTIFICATION_THEME_CHANGEDでqueue_sortが呼ばれる | E-03 (185-197行目) | ○ |
| C-14 | BoxContainer等の派生クラスで使用される | ソースコード確認 | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張に明確な根拠あり
- 0: 低リスク - 通知発火ロジックがソースコードで確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] 通知値50がcontainer.hで正しく定義されていることを確認
- [ ] _sort_children()でPRE_SORT_CHILDRENがSORT_CHILDRENより先に発火することを確認
- [ ] pre_sort_childrenシグナルが同時に発火されることを確認
