---
generated_at: 2026-01-23 16:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：66-NOTIFICATION_SORT_CHILDREN

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `scene/gui/container.h` 65行目 - NOTIFICATION_SORT_CHILDREN定数定義（51）
- E-02: `scene/gui/container.cpp` 90行目 - notification(NOTIFICATION_SORT_CHILDREN)呼び出し
- E-03: `scene/gui/container.cpp` 91行目 - emit_signal(sort_children)呼び出し
- E-04: `scene/gui/container.cpp` 95-128行目 - fit_child_in_rect()メソッド実装
- E-05: `scene/gui/container.cpp` 225行目 - BIND_CONSTANT定義
- E-06: `scene/gui/container.cpp` 228行目 - sort_childrenシグナル定義
- E-07: `scene/gui/box_container.cpp` - NOTIFICATION_SORT_CHILDREN処理
- E-08: `scene/gui/grid_container.cpp` - NOTIFICATION_SORT_CHILDREN処理
- E-09: `scene/gui/margin_container.cpp` - NOTIFICATION_SORT_CHILDREN処理

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知値は51である | E-01 (container.h:65) | ○ |
| C-02 | Containerクラスで定義されている | E-01 | ○ |
| C-03 | PRE_SORT_CHILDRENの直後に送信される | E-02 (container.cpp:90) | ○ |
| C-04 | sort_childrenシグナルも同時に発火される | E-03 | ○ |
| C-05 | fit_child_in_rectで子コントロールを配置する | E-04 | ○ |
| C-06 | pending_sortがfalseにリセットされる | E-02 (container.cpp:92) | ○ |
| C-07 | BIND_CONSTANTでスクリプトに公開されている | E-05 | ○ |
| C-08 | BoxContainerがこの通知を処理する | E-07 | ○ |
| C-09 | GridContainerがこの通知を処理する | E-08 | ○ |
| C-10 | MarginContainerがこの通知を処理する | E-09 | ○ |
| C-11 | PRE_SORT_CHILDRENが対となる通知 | E-01 (container.h:64) | ○ |
| C-12 | 同期的に送信される | E-02 (notification直接呼び出し) | ○ |
| C-13 | add_child_notifyでqueue_sortが呼ばれる | container.cpp:38-52 | ○ |
| C-14 | as_sortable_controlで子ノードをフィルタリング | container.cpp:143-155 | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張に明確な根拠あり
- 0: 低リスク - 通知発火と派生クラス処理がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] 通知値51がcontainer.hで正しく定義されていることを確認
- [ ] _sort_children()でPRE_SORT_CHILDRENの後にSORT_CHILDRENが発火することを確認
- [ ] 各派生クラスでNOTIFICATION_SORT_CHILDRENが処理されていることを確認
