---
generated_at: 2026-01-23 16:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：67-NOTIFICATION_UPDATE_SKELETON

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `scene/3d/skeleton_3d.h` 220-222行目 - NOTIFICATION_UPDATE_SKELETON定数定義（50）
- E-02: `scene/3d/skeleton_3d.h` 88-92行目 - UpdateFlag定義
- E-03: `scene/3d/skeleton_3d.cpp` 288-310行目 - _notification()メソッド実装
- E-04: `scene/3d/skeleton_3d.cpp` 311-400行目 - NOTIFICATION_UPDATE_SKELETON処理
- E-05: `scene/3d/skeleton_3d.cpp` 347行目 - skeleton_updatedシグナル発火
- E-06: `scene/3d/skeleton_3d.cpp` 304-307行目 - EDITOR_PRE_SAVE/POST_SAVE処理
- E-07: `scene/3d/skeleton_3d.h` 79-83行目 - ModifierCallbackModeProcess定義
- E-08: `scene/3d/bone_attachment_3d.cpp` - BoneAttachment3D実装

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知値は50である | E-01 (skeleton_3d.h:221) | ○ |
| C-02 | Skeleton3Dクラスで定義されている | E-01 | ○ |
| C-03 | force_update_all_dirty_bones()が呼び出される | E-04 (313行目) | ○ |
| C-04 | skeleton_updatedシグナルが発火される | E-05 | ○ |
| C-05 | POST_ENTER_TREE後に初回更新が発生する | E-03 (296-302行目) | ○ |
| C-06 | updatingフラグで再入を防止する | E-04 (315行目) | ○ |
| C-07 | UPDATE_FLAG_POSEで更新条件をチェック | E-02, E-04 (341行目) | ○ |
| C-08 | モディファイア処理が含まれる | E-04 (325-337行目) | ○ |
| C-09 | スキンバインド更新が行われる | E-04 (349-400行目) | ○ |
| C-10 | EDITOR_PRE_SAVE時にsavingフラグが設定される | E-06 (304行目) | ○ |
| C-11 | EDITOR_POST_SAVE時にsavingフラグがリセットされる | E-06 (307行目) | ○ |
| C-12 | ModifierCallbackModeProcessで処理タイミング制御 | E-07 | ○ |
| C-13 | RenderingServer::skeleton_bone_set_transformが呼ばれる | E-04 (400行目付近) | ○ |
| C-14 | BoneAttachment3Dがスケルトン更新を受け取る | E-08 | ○ |
| C-15 | 同期的に送信される | E-04 (notification直接呼び出し) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張に明確な根拠あり
- 0: 低リスク - スケルトン更新ロジックがソースコードで確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] 通知値50がskeleton_3d.hで正しく定義されていることを確認
- [ ] _notification()でNOTIFICATION_UPDATE_SKELETONが処理されることを確認
- [ ] skeleton_updatedシグナルが発火されることを確認
- [ ] スキンバインド更新がRenderingServerに反映されることを確認
