---
generated_at: 2026-01-23 16:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：68-NOTIFICATION_EDITOR_PRE_SAVE

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `scene/main/node.h` 501行目 - NOTIFICATION_EDITOR_PRE_SAVE定数定義（9001）
- E-02: `editor/editor_node.cpp` 2414行目 - propagate_notification(NOTIFICATION_EDITOR_PRE_SAVE)呼び出し
- E-03: `editor/editor_node.cpp` 2491行目 - propagate_notification(NOTIFICATION_EDITOR_POST_SAVE)呼び出し
- E-04: `scene/3d/skeleton_3d.cpp` 304-306行目 - NOTIFICATION_EDITOR_PRE_SAVE処理
- E-05: `editor/editor_node.cpp` 2400-2493行目 - _save_scene()メソッド全体
- E-06: `doc/classes/Node.xml` - 公式ドキュメント

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知値は9001である | E-01 (node.h:501) | ○ |
| C-02 | Nodeクラスで定義されている | E-01 | ○ |
| C-03 | EditorNode::_save_scene()で送信される | E-02 | ○ |
| C-04 | PackedScene::pack()の直前に送信される | E-02, E-05 (2414行→2438行) | ○ |
| C-05 | propagate_notificationで全子孫に伝播 | E-02 | ○ |
| C-06 | NOTIFICATION_EDITOR_POST_SAVEが対となる通知 | E-01, E-03 | ○ |
| C-07 | Skeleton3Dでsaving=trueが設定される | E-04 | ○ |
| C-08 | シーンルートがnullの場合はエラー | E-05 (2404-2406行目) | ○ |
| C-09 | 循環参照があると保存中止 | E-05 (2409-2411行目) | ○ |
| C-10 | エディタビルドでのみ有効 | E-04 (#ifdef TOOLS_ENABLED) | ○ |
| C-11 | 同期的に送信される | E-02 (propagate_notification) | ○ |
| C-12 | editor_data.apply_changes_in_editors()が呼ばれる | E-05 (2416行目) | ○ |
| C-13 | ResourceSaver::save()で保存される | E-05 (2451行目) | ○ |
| C-14 | ゲーム実行時には発生しない | E-04 (TOOLS_ENABLEDマクロ) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張に明確な根拠あり
- 0: 低リスク - エディタ保存処理がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] 通知値9001がnode.hで正しく定義されていることを確認
- [ ] editor_node.cppでPRE_SAVEがPOST_SAVEより先に発火することを確認
- [ ] Skeleton3Dでsavingフラグが正しく設定されることを確認
