---
generated_at: 2026-01-23 16:25:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：69-NOTIFICATION_EDITOR_POST_SAVE

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `scene/main/node.h` 502行目 - NOTIFICATION_EDITOR_POST_SAVE定数定義（9002）
- E-02: `editor/editor_node.cpp` 2491行目 - propagate_notification(NOTIFICATION_EDITOR_POST_SAVE)呼び出し
- E-03: `editor/editor_node.cpp` 2414行目 - PRE_SAVE呼び出し（対通知）
- E-04: `scene/3d/skeleton_3d.cpp` 307-309行目 - NOTIFICATION_EDITOR_POST_SAVE処理
- E-05: `editor/editor_node.cpp` 2400-2493行目 - _save_scene()メソッド全体
- E-06: `doc/classes/Node.xml` - 公式ドキュメント

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知値は9002である | E-01 (node.h:502) | ○ |
| C-02 | Nodeクラスで定義されている | E-01 | ○ |
| C-03 | EditorNode::_save_scene()で送信される | E-02 | ○ |
| C-04 | ResourceSaver::save()の後に送信される | E-02, E-05 (2451行→2491行) | ○ |
| C-05 | propagate_notificationで全子孫に伝播 | E-02 | ○ |
| C-06 | NOTIFICATION_EDITOR_PRE_SAVEが対となる通知 | E-01, E-03 | ○ |
| C-07 | Skeleton3Dでsaving=falseがクリアされる | E-04 | ○ |
| C-08 | 保存失敗後も送信される | E-05 (2491行目は無条件実行) | ○ |
| C-09 | エディタビルドでのみ有効 | E-04 (#ifdef TOOLS_ENABLED) | ○ |
| C-10 | 同期的に送信される | E-02 (propagate_notification) | ○ |
| C-11 | PRE_SAVEとPOST_SAVEは必ずペアで発生 | E-05 | ○ |
| C-12 | ゲーム実行時には発生しない | E-04 (TOOLS_ENABLEDマクロ) | ○ |
| C-13 | PRE_SAVEとPOST_SAVEは連番で定義 | E-01 (9001, 9002) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張に明確な根拠あり
- 0: 低リスク - エディタ保存処理がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] 通知値9002がnode.hで正しく定義されていることを確認
- [ ] editor_node.cppでPOST_SAVEがResourceSaver::save()の後に発火することを確認
- [ ] Skeleton3Dでsavingフラグが正しくクリアされることを確認
