---
generated_at: 2026-01-23 16:30:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-Logger WARNING

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `core/core_bind.h` 129行目 - ERROR_TYPE_WARNING = 1
- E-02: `core/io/logger.h` 52行目 - ERR_WARNING = 1
- E-03: `core/error/error_macros.h` 713-714行目 - WARN_PRINTマクロ定義
- E-04: `core/io/logger.cpp` 255-262行目 - CompositeLogger::log_error
- E-05: `core/core_bind.h` 136行目 - GDVIRTUAL8(_log_error, ...)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ERROR_TYPE_WARNINGは列挙値1である | E-01 | ○ |
| C-02 | Logger::ERR_WARNINGは値1である | E-02 | ○ |
| C-03 | WARN_PRINTはERR_HANDLER_WARNINGを使用する | E-03 | ○ |
| C-04 | CompositeLoggerが全ロガーに通知する | E-04 | ○ |
| C-05 | _log_errorにp_typeとして渡される | E-05 | ○ |
| C-06 | push_warningからも通知される | variant_utility.cpp 1034行目 | ○ |
| C-07 | ERROR_TYPE_WARNINGとERR_WARNINGは同値 | E-01, E-02比較 | ○ |
| C-08 | GDScriptから_log_errorをオーバーライド可能 | E-05 (GDVIRTUAL) | ○ |
| C-09 | すべての登録ロガーに通知される | E-04 | ○ |
| C-10 | p_typeでエラータイプを識別する | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] ERROR_TYPE_WARNING=1の確認
- [ ] WARN_PRINTマクロがERR_HANDLER_WARNINGを使用することの確認
- [ ] p_typeで警告タイプを識別できることの確認
