---
generated_at: 2026-01-23 16:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：70-NOTIFICATION_RESET_PHYSICS_INTERPOLATION

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `scene/main/node.h` 471行目 - NOTIFICATION_RESET_PHYSICS_INTERPOLATION定数定義（2001）
- E-02: `scene/main/node.cpp` 967-976行目 - reset_physics_interpolation()メソッド実装
- E-03: `scene/main/node.cpp` 963-964行目 - set_physics_interpolation_mode()での通知発火
- E-04: `scene/3d/node_3d.cpp` 285-291行目 - Node3Dでの通知処理
- E-05: `scene/main/canvas_item.cpp` 427行目 - CanvasItemでの通知処理
- E-06: `scene/2d/camera_2d.cpp` 309-310行目 - Camera2Dでの通知処理
- E-07: `scene/main/scene_tree_fti.cpp` - FTI実装
- E-08: `scene/main/node.cpp` 236-240行目 - NOTIFICATION_PAUSEDでの補間リセット

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知値は2001である | E-01 (node.h:471) | ○ |
| C-02 | Nodeクラスで定義されている | E-01 | ○ |
| C-03 | reset_physics_interpolation()で発火される | E-02 (969行目) | ○ |
| C-04 | propagate_notificationで子孫に伝播 | E-02 | ○ |
| C-05 | SceneTree::is_fti_enabled()がチェックされる | E-02 (968行目) | ○ |
| C-06 | is_inside_tree()がチェックされる | E-02 (968行目) | ○ |
| C-07 | set_physics_interpolation_mode()でも発火 | E-03 | ○ |
| C-08 | Node3Dで_reset_physics_interpolation_client()が呼ばれる | E-04 | ○ |
| C-09 | CanvasItemで補間リセット処理が行われる | E-05 | ○ |
| C-10 | Camera2Dで_reset_physics_interpolation_client()が呼ばれる | E-06 | ○ |
| C-11 | 2001は「A GodotSpace Odyssey」のパロディ | E-01 (コメント) | ○ |
| C-12 | _propagate_physics_interpolation_reset_requested()で自動リセット制御 | E-02 (975行目) | ○ |
| C-13 | NOTIFICATION_PAUSEDで補間リセットが発生 | E-08 | ○ |
| C-14 | FTI無効時は通知送信がスキップされる | E-02 (条件分岐) | ○ |
| C-15 | ツリー外では通知送信がスキップされる | E-02 (条件分岐) | ○ |
| C-16 | 同期的に送信される | E-02 (propagate_notification) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張に明確な根拠あり
- 0: 低リスク - 補間リセット処理がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] 通知値2001がnode.hで正しく定義されていることを確認
- [ ] reset_physics_interpolation()でFTI有効チェックが行われることを確認
- [ ] Node3D、CanvasItem等で通知が処理されることを確認
- [ ] 「A GodotSpace Odyssey」のコメントが存在することを確認
