---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：71-NOTIFICATION_ACCESSIBILITY_UPDATE

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **AccessKitドライバーの詳細仕様**：ドライバー実装の詳細確認が必要
  2. **SceneTreeのキュー管理詳細**：内部キューイング処理の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/main/node.h` 行449-475（通知定数定義）
- E-02: `scene/main/node.cpp` 行60-90（_notification処理）
- E-03: `scene/main/node.cpp` 行3736-3740（queue_accessibility_update実装）
- E-04: `doc/classes/Node.xml` 行1326-1331（公式ドキュメント）
- E-05: `scene/main/node.cpp` 行99-111（NOTIFICATION_ENTER_TREE処理）
- E-06: `drivers/accesskit/accessibility_driver_accesskit.cpp`（AccessKitドライバー）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_ACCESSIBILITY_UPDATEの値は3000 | E-01 | ○ |
| C-02 | 通知受信時にget_accessibility_element()でRIDを取得 | E-02 | ○ |
| C-03 | DisplayServerを通じてアクセシビリティ情報を更新 | E-02 | ○ |
| C-04 | queue_accessibility_update()で通知をキューに追加 | E-03 | ○ |
| C-05 | is_inside_tree()チェックを行う | E-03 | ○ |
| C-06 | is_part_of_edited_scene()チェックを行う | E-03 | ○ |
| C-07 | NOTIFICATION_ENTER_TREE発火時にアクセシビリティ更新 | E-05 | ○ |
| C-08 | 子ノードのアクセシビリティ要素を追加 | E-02 | ○ |
| C-09 | accessibility_update_set_name()でノード名を設定 | E-02 | ○ |
| C-10 | Windowノードの可視性チェックを行う | E-02 | ○ |
| C-11 | accessibility_override_tree_hierarchy()で階層をカスタマイズ可能 | E-02 | ○ |
| C-12 | エディタシーンの一部は除外される | E-02, E-03 | ○ |
| C-13 | アクセシビリティ要素が無効な場合ERR_FAIL_COND | E-02 | ○ |
| C-14 | 公式ドキュメントに通知定義あり | E-04 | ○ |
| C-15 | SceneTreeで通知管理される | E-05 | ○ |
| C-16 | AccessKitドライバーでクロスプラットフォームサポート | E-06 | ○ |
| C-17 | 通知キューの詳細な管理方式 | **根拠なし** | △ |
| C-18 | レート制限・重複排除の具体的実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- SceneTree内の通知キュー管理の詳細実装
  - 候補：scene_tree.cpp / scene_tree.h / 追加調査が必要
- レート制限・重複排除の具体的な実装詳細
  - 候補：コードベースの追加調査が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 通知定数と基本的な処理フローは確実
- 1: 中リスク - キュー管理の詳細は追加調査推奨
- 0: 低リスク - 公式ドキュメントと実装が一致

## 6) レビュアーチェックリスト（最小）
- [ ] node.cppの_notification処理（行69-89）が設計書と一致するか確認
- [ ] queue_accessibility_update()の実装（行3736-3740）が正確か確認
- [ ] SceneTreeのアクセシビリティ通知管理の詳細を追加調査
- [ ] AccessKitドライバーの実装詳細を必要に応じて確認
