---
generated_at: 2026-01-23 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：72-NOTIFICATION_ACCESSIBILITY_INVALIDATE

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **アクセシビリティ再初期化のトリガー詳細**：具体的な再初期化シナリオの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/main/node.h` 行475（通知定数定義 NOTIFICATION_ACCESSIBILITY_INVALIDATE = 3001）
- E-02: `scene/main/node.cpp` 行62-67（_notification内NOTIFICATION_ACCESSIBILITY_INVALIDATE処理）
- E-03: `scene/main/node.cpp` 行186-201（NOTIFICATION_EXIT_TREE処理内のアクセシビリティ解放）
- E-04: `doc/classes/Node.xml` 行1329-1331（公式ドキュメント）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_ACCESSIBILITY_INVALIDATEの値は3001 | E-01 | ○ |
| C-02 | 通知受信時にaccessibility_element.is_valid()チェック | E-02 | ○ |
| C-03 | DisplayServer::accessibility_free_element()でリソース解放 | E-02, E-03 | ○ |
| C-04 | accessibility_element = RID()で初期化 | E-02, E-03 | ○ |
| C-05 | NOTIFICATION_EXIT_TREE処理内でアクセシビリティ解放 | E-03 | ○ |
| C-06 | is_part_of_edited_scene()チェックを行う | E-03 | ○ |
| C-07 | 既存のアクセシビリティ要素への参照は無効となる | E-04 | ○ |
| C-08 | 二重解放防止のためis_valid()チェックを実施 | E-02 | ○ |
| C-09 | 親ノードへの通知（_accessibility_notify_change） | E-03 | ○ |
| C-10 | シーンツリーのアクセシビリティサポートチェック | E-03 | ○ |
| C-11 | 公式ドキュメントに通知定義あり | E-04 | ○ |
| C-12 | NOTIFICATION_ACCESSIBILITY_UPDATEと対になる通知 | E-01, E-04 | ○ |
| C-13 | Godot 4.xで追加されたアクセシビリティシステムの一部 | E-04 | ○ |
| C-14 | アクセシビリティシステム再初期化時のトリガー詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- アクセシビリティシステム再初期化の具体的なシナリオ
  - 候補：display_server.cpp / scene_tree.cpp / 追加調査が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 通知定数と基本的な処理フローは確実
- 0: 低リスク - リソース解放処理は明確に実装されている
- 1: 中リスク - 再初期化シナリオは追加調査推奨

## 6) レビュアーチェックリスト（最小）
- [ ] node.cppの_notification処理（行62-67）が設計書と一致するか確認
- [ ] NOTIFICATION_EXIT_TREE処理（行186-201）内のアクセシビリティ解放処理を確認
- [ ] is_valid()チェックによる二重解放防止が正しく機能するか確認
