---
generated_at: 2026-01-23 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：73-script_changed

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **同一スクリプト再設定時の挙動**：具体的な比較ロジックの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/object/object.cpp` 行1091-1098（set_script実装）
- E-02: `core/object/object.cpp` 行2006-2007（シグナル定義）
- E-03: `doc/classes/Object.xml` 行1022-1027（公式ドキュメント）
- E-04: `editor/scene/scene_tree_editor.cpp`（エディタでの利用例）
- E-05: `editor/script/script_editor_plugin.cpp`（スクリプトエディタでの利用例）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | script_changedシグナルはObjectクラスで定義 | E-02 | ○ |
| C-02 | set_script()呼び出し時にシグナル発火 | E-01 | ○ |
| C-03 | emit_signal(CoreStringName(script_changed))で発火 | E-01 | ○ |
| C-04 | notify_property_list_changed()が先に呼び出される | E-01 | ○ |
| C-05 | シグナルにはパラメータがない | E-02 | ○ |
| C-06 | 新しいスクリプトはget_script()で取得 | E-03 | ○ |
| C-07 | CONNECT_DEFERREDでの接続が推奨 | E-03 | ○ |
| C-08 | スクリプトがnullの場合も発火 | E-01 | ○ |
| C-09 | エディタでの利用例（SceneTreeEditor） | E-04 | ○ |
| C-10 | スクリプトエディタでの利用例 | E-05 | ○ |
| C-11 | property_list_changedと連動 | E-01 | ○ |
| C-12 | プレースホルダーインスタンスのサポート | E-01 | ○ |
| C-13 | 公式ドキュメントにシグナル定義あり | E-03 | ○ |
| C-14 | スクリプトインスタンス作成後にシグナル発火 | E-01 | ○ |
| C-15 | 同一スクリプト再設定時のシグナル抑止ロジック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 同一スクリプト再設定時の比較ロジックの詳細
  - 候補：object.cpp内のset_script()の詳細実装確認が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シグナル定義と基本的な発火フローは確実
- 0: 低リスク - 公式ドキュメントと実装が一致
- 1: 中リスク - エッジケース（同一スクリプト再設定）は追加確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] object.cppのset_script()実装（行1091-1098付近）が設計書と一致するか確認
- [ ] シグナル定義（行2006-2007）が正確か確認
- [ ] 同一スクリプト再設定時の挙動を実機で確認
- [ ] CONNECT_DEFERREDの使用が実際に必要か確認
