---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：74-property_list_changed

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/object/object.cpp` 行1912-1914（notify_property_list_changed実装）
- E-02: `core/object/object.cpp` 行2007（シグナル定義）
- E-03: `core/object/object.cpp` 行1096（set_script内での呼び出し）
- E-04: `core/object/object.cpp` 行1145（set_meta内での呼び出し）
- E-05: `core/object/object.cpp` 行1129（remove_meta内での呼び出し）
- E-06: `doc/classes/Object.xml` 行830-834、1017-1020（公式ドキュメント）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | property_list_changedシグナルはObjectクラスで定義 | E-02 | ○ |
| C-02 | notify_property_list_changed()でシグナル発火 | E-01 | ○ |
| C-03 | emit_signal(CoreStringName(property_list_changed))で発火 | E-01 | ○ |
| C-04 | シグナルにはパラメータがない | E-02 | ○ |
| C-05 | set_script()内で自動呼び出し | E-03 | ○ |
| C-06 | set_meta()でメタデータ追加時に呼び出し | E-04 | ○ |
| C-07 | remove_meta()でメタデータ削除時に呼び出し | E-05 | ○ |
| C-08 | _で始まるメタキーの場合は呼び出されない | E-04, E-05 | ○ |
| C-09 | 公式ドキュメントにシグナル定義あり | E-06 | ○ |
| C-10 | 公式ドキュメントにnotify_property_list_changed説明あり | E-06 | ○ |
| C-11 | エディタインスペクターの更新に使用 | E-06 | ○ |
| C-12 | _get_property_list()と組み合わせて動的プロパティ実現 | E-06 | ○ |
| C-13 | @toolスクリプトでの利用が推奨される | E-06 | ○ |
| C-14 | 実装は単純なemit_signal呼び出し | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 実装が非常にシンプルで確実
- 0: 低リスク - 公式ドキュメントと実装が完全に一致

## 6) レビュアーチェックリスト（最小）
- [ ] object.cppのnotify_property_list_changed()実装（行1912-1914）が設計書と一致するか確認
- [ ] シグナル定義（行2007）が正確か確認
- [ ] set_script()、set_meta()、remove_meta()での呼び出し条件を確認
