---
generated_at: 2026-01-23 10:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：75-tree_entered

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/main/node.cpp` 行335-383（_propagate_enter_tree実装）
- E-02: `scene/main/node.cpp` 行358（emit_signal tree_entered）
- E-03: `scene/main/node.cpp` 行4025（シグナル定義）
- E-04: `doc/classes/Node.xml` 行1143-1147（公式ドキュメント）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | tree_enteredシグナルはNodeクラスで定義 | E-03 | ○ |
| C-02 | _propagate_enter_tree()内でシグナル発火 | E-01, E-02 | ○ |
| C-03 | NOTIFICATION_ENTER_TREEの後に発火 | E-01 | ○ |
| C-04 | _enter_tree()仮想メソッドの後に発火 | E-01 | ○ |
| C-05 | シグナルにはパラメータがない | E-03 | ○ |
| C-06 | add_child()で発火 | E-01 | ○ |
| C-07 | ツリー/Viewport設定後に発火 | E-01 | ○ |
| C-08 | グループへの追加後に発火 | E-01 | ○ |
| C-09 | SceneTree.node_added()が呼ばれる | E-01 | ○ |
| C-10 | 親ノードにchild_entered_tree発火 | E-01 | ○ |
| C-11 | 子ノードの処理は再帰的に行われる | E-01 | ○ |
| C-12 | 公式ドキュメントにシグナル定義あり | E-04 | ○ |
| C-13 | NOTIFICATION_ENTER_TREEの後に発火（ドキュメント） | E-04 | ○ |
| C-14 | SceneStringNameでシグナル名を参照 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 実装と公式ドキュメントが一致
- 0: 低リスク - 発火順序が明確に定義されている

## 6) レビュアーチェックリスト（最小）
- [ ] node.cppの_propagate_enter_tree()実装（行335-383）が設計書と一致するか確認
- [ ] シグナル発火位置（行358）が正確か確認
- [ ] シグナル定義（行4025）が正確か確認
