---
generated_at: 2026-01-23 11:00:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：77-tree_exited

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/main/node.cpp` 行385-402（_propagate_after_exit_tree実装）
- E-02: `scene/main/node.cpp` 行401（emit_signal tree_exited）
- E-03: `scene/main/node.cpp` 行4027（シグナル定義）
- E-04: `doc/classes/Node.xml` 行1149-1153（公式ドキュメント）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | tree_exitedシグナルはNodeクラスで定義 | E-03 | ○ |
| C-02 | _propagate_after_exit_tree()内でシグナル発火 | E-01, E-02 | ○ |
| C-03 | NOTIFICATION_EXIT_TREEの後に発火 | E-01, E-04 | ○ |
| C-04 | シグナルにはパラメータがない | E-03 | ○ |
| C-05 | ノードはすでにツリーから切り離されている | E-01, E-04 | ○ |
| C-06 | 子ノードの処理は逆順で行われる | E-01 | ○ |
| C-07 | オーナーのクリーンアップが行われる（条件付き） | E-01 | ○ |
| C-08 | tree_exitingの後に発火 | E-01, E-04 | ○ |
| C-09 | 公式ドキュメントにシグナル定義あり | E-04 | ○ |
| C-10 | is_inside_tree()がfalseを返す状態 | E-04 | ○ |
| C-11 | _propagate_exit_tree()完了後に呼ばれる | E-01 | ○ |
| C-12 | _clean_up_owner()が呼ばれる（条件付き） | E-01 | ○ |
| C-13 | SceneStringNameでシグナル名を参照 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 実装と公式ドキュメントが一致
- 0: 低リスク - 発火タイミングが明確に定義されている

## 6) レビュアーチェックリスト（最小）
- [ ] node.cppの_propagate_after_exit_tree()実装（行385-402）が設計書と一致するか確認
- [ ] シグナル発火位置（行401）が正確か確認
- [ ] オーナークリーンアップ条件を確認
