---
generated_at: 2026-01-23 11:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：79-child_exiting_tree

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/main/node.cpp` 行430-434（emit_signalp child_exiting_tree）
- E-02: `scene/main/node.cpp` 行4029（シグナル定義）
- E-03: `doc/classes/Node.xml` 行1103-1108（公式ドキュメント）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | child_exiting_treeシグナルはNodeクラスで定義 | E-02 | ○ |
| C-02 | _propagate_exit_tree()内でシグナル発火 | E-01 | ○ |
| C-03 | 子のtree_exitingの後に発火 | E-01 | ○ |
| C-04 | 子のNOTIFICATION_EXIT_TREEの後に発火 | E-01 | ○ |
| C-05 | パラメータとして子ノードが渡される | E-01, E-02 | ○ |
| C-06 | data.parentが存在する場合のみ発火 | E-01 | ○ |
| C-07 | emit_signalpで発火（Variant配列） | E-01 | ○ |
| C-08 | SNAME("child_exiting_tree")で名前参照 | E-01 | ○ |
| C-09 | シグナル定義にNodeパラメータあり | E-02 | ○ |
| C-10 | 公式ドキュメントにシグナル定義あり | E-03 | ○ |
| C-11 | 子ノードはまだアクセス可能（ドキュメント） | E-03 | ○ |
| C-12 | 子のツリー退出処理中に発火 | E-03 | ○ |
| C-13 | SceneTree.node_removed後に発火 | E-01 | ○ |
| C-14 | グループ削除前に発火 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 実装と公式ドキュメントが一致
- 0: 低リスク - パラメータ仕様が明確

## 6) レビュアーチェックリスト（最小）
- [ ] node.cppのemit_signalp呼び出し（行430-434）が設計書と一致するか確認
- [ ] シグナル定義（行4029）が正確か確認
- [ ] パラメータ型（Node）が正しいか確認
