---
generated_at: 2026-01-23 16:35:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-Logger SCRIPT

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `core/core_bind.h` 130行目 - ERROR_TYPE_SCRIPT = 2
- E-02: `core/io/logger.h` 53行目 - ERR_SCRIPT = 2
- E-03: `core/io/logger.h` 64行目 - "SCRIPT ERROR" 文字列
- E-04: `core/io/logger.h` 78行目 - 10スペースインデント
- E-05: `core/error/error_macros.h` 45行目 - ERR_HANDLER_SCRIPT
- E-06: `core/io/logger.cpp` 58-80行目 - log_error実装
- E-07: `core/core_bind.h` 136行目 - GDVIRTUAL8(_log_error, ...)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ERROR_TYPE_SCRIPTは列挙値2である | E-01 | ○ |
| C-02 | Logger::ERR_SCRIPTは値2である | E-02 | ○ |
| C-03 | 標準出力では「SCRIPT ERROR:」プレフィックス | E-03 | ○ |
| C-04 | インデントは10スペースである | E-04 | ○ |
| C-05 | ERR_HANDLER_SCRIPT列挙値が存在する | E-05 | ○ |
| C-06 | スクリプトバックトレースが渡される | E-07 (TypedArray<ScriptBacktrace>) | ○ |
| C-07 | _log_errorにp_typeとして渡される | E-07 | ○ |
| C-08 | GDScriptから_log_errorをオーバーライド可能 | E-07 (GDVIRTUAL) | ○ |
| C-09 | ERROR_TYPE_SCRIPTとERR_SCRIPTは同値 | E-01, E-02比較 | ○ |
| C-10 | CompositeLoggerが全ロガーに通知する | logger.cpp 255-262行目 | ○ |
| C-11 | スクリプトファイルパスが渡される | E-07 (p_file引数) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] ERROR_TYPE_SCRIPT=2の確認
- [ ] 「SCRIPT ERROR:」プレフィックスの確認
- [ ] スクリプトバックトレースが正しく渡されることの確認
- [ ] p_typeでスクリプトエラータイプを識別できることの確認
