---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：80-NOTIFICATION_DRAG_BEGIN

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/main/node.h` 行462（通知定数定義 NOTIFICATION_DRAG_BEGIN = 21）
- E-02: `scene/main/viewport.cpp` 行1333-1343（_propagate_drag_notification実装）
- E-03: `scene/main/viewport.cpp` 行2063-2066（GUI入力処理内のドラッグ通知）
- E-04: `scene/main/viewport.cpp` 行2482（force_drag内の通知）
- E-05: `scene/main/node.cpp` 行3951-3952（BIND_CONSTANT定義）
- E-06: `doc/classes/Node.xml` 行1200-1204（公式ドキュメント）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_DRAG_BEGINの値は21 | E-01, E-05 | ○ |
| C-02 | _propagate_drag_notification()で伝播 | E-02 | ○ |
| C-03 | すべてのノードに通知される | E-02, E-06 | ○ |
| C-04 | SubViewport（非埋め込み）は除外 | E-02 | ○ |
| C-05 | SubViewportContainerの子かどうかをチェック | E-02 | ○ |
| C-06 | gui.draggingがtrueの時に発火 | E-03 | ○ |
| C-07 | force_drag()でも発火 | E-04 | ○ |
| C-08 | section_rootから伝播開始 | E-03, E-04 | ○ |
| C-09 | NOTIFICATION_DRAG_END（22）とペア | E-05 | ○ |
| C-10 | gui_get_drag_data()でデータ取得可能 | E-06 | ○ |
| C-11 | _get_drag_data()がデータを返した時に開始 | E-06 | ○ |
| C-12 | 公式ドキュメントに通知定義あり | E-06 | ○ |
| C-13 | 通知パラメータなし | E-02 | ○ |
| C-14 | 再帰的に子ノードへ伝播 | E-02 | ○ |
| C-15 | Viewportのセクションルートから開始 | E-03, E-04 | ○ |
| C-16 | drag_attemptedフラグによる制御 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 実装と公式ドキュメントが一致
- 0: 低リスク - 伝播ロジックが明確に定義されている

## 6) レビュアーチェックリスト（最小）
- [ ] viewport.cppの_propagate_drag_notification()実装（行1333-1343）が設計書と一致するか確認
- [ ] 通知発火箇所（行2063-2066、2482）が正確か確認
- [ ] SubViewportの除外条件が正しいか確認
