---
generated_at: 2026-01-23 15:45:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：81-NOTIFICATION_DRAG_END.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠が存在

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/main/node.h:463` - NOTIFICATION_DRAG_END = 22 の定義
- E-02: `scene/main/node.cpp:3952` - BIND_CONSTANT(NOTIFICATION_DRAG_END)
- E-03: `scene/main/viewport.cpp:2412-2435` - gui_perform_drop_at()関数の実装
- E-04: `scene/main/viewport.cpp:1333-1344` - _propagate_drag_notification()関数の実装
- E-05: `scene/main/viewport.cpp:3900-3903` - gui_is_drag_successful()関数の実装
- E-06: `scene/main/viewport.h:297` - _propagate_drag_notification()宣言
- E-07: `doc/classes/Node.xml:1205-1208` - NOTIFICATION_DRAG_ENDの公式ドキュメント
- E-08: `doc/classes/Viewport.xml:188-192` - gui_is_drag_successful()のドキュメント
- E-09: `doc/classes/Control.xml:748-753` - is_drag_successful()のドキュメント
- E-10: `scene/gui/line_edit.cpp:1707-1723` - LineEditでの受信処理実装
- E-11: `scene/gui/text_edit.cpp:2012-2026` - TextEditでの受信処理実装
- E-12: `scene/gui/tree.cpp:5019-5024` - Treeでの受信処理実装
- E-13: `scene/gui/tab_bar.cpp:497-509` - TabBarでの受信処理実装
- E-14: `scene/gui/scroll_container.cpp:478-486` - ScrollContainerでの受信処理実装
- E-15: `editor/docks/filesystem_dock.cpp:611-618` - FilesystemDockでの受信処理実装
- E-16: `editor/inspector/editor_inspector.cpp:2204-2210` - EditorInspectorでの受信処理実装
- E-17: `scene/gui/control.cpp:2252` - Control::is_drag_successful()の実装
- E-18: `tests/scene/test_viewport.h:133-136` - DragTargetテストクラスでの受信処理
- E-19: `scene/main/viewport.cpp:2482` - force_dragからのNOTIFICATION_DRAG_BEGIN発火箇所
- E-20: `scene/main/viewport.cpp:2065` - ドラッグ開始時のNOTIFICATION_DRAG_BEGIN発火箇所

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_DRAG_ENDの値は22である | E-01, E-02 | ○ |
| C-02 | ドラッグ終了時にシーンツリー内のすべてのノードに伝播される | E-04, E-07 | ○ |
| C-03 | SubViewportContainer経由でないSubViewportはスキップされる | E-04 | ○ |
| C-04 | gui_perform_drop_at()がドラッグ終了のエントリーポイントである | E-03 | ○ |
| C-05 | ドラッグプレビューは終了時に削除される | E-03 (2420-2424行) | ○ |
| C-06 | gui.drag_dataはVariant()でクリアされる | E-03 (2427行) | ○ |
| C-07 | gui.draggingはfalseに設定される | E-03 (2428行) | ○ |
| C-08 | gui.global_draggingはfalseに設定される | E-03 (2430行) | ○ |
| C-09 | 通知後にupdate_mouse_cursor_state()が呼ばれる | E-03 (2434行) | ○ |
| C-10 | Viewport.gui_is_drag_successful()でドラッグ成否を確認できる | E-05, E-08 | ○ |
| C-11 | Control.is_drag_successful()はViewport.gui_is_drag_successful()の代替 | E-09, E-17 | ○ |
| C-12 | LineEditではドラッグ成功時に選択テキストを削除する | E-10 (1711-1712行) | ○ |
| C-13 | TextEditではドラッグ成功時に選択を削除する | E-11 (2016-2017行) | ○ |
| C-14 | Treeではdrop_mode_flagsを0にリセットする | E-12 (5020行) | ○ |
| C-15 | TabBarではdragging_valid_tabをfalseにリセットする | E-13 (498-500行) | ○ |
| C-16 | ScrollContainerではset_process_internal(false)を呼ぶ | E-14 (485行) | ○ |
| C-17 | FilesystemDockではtree.set_drop_mode_flags(0)を呼ぶ | E-15 (612行) | ○ |
| C-18 | EditorInspectorではdropping_for_unfoldをfalseにする | E-16 (2209行) | ○ |
| C-19 | _propagate_drag_notificationは再帰的に子ノードに伝播する | E-04 (1342行) | ○ |
| C-20 | 各ノードにnotification(p_what)が呼ばれる | E-04 (1335行) | ○ |
| C-21 | NOTIFICATION_DRAG_BEGIN(21)と対になる通知である | E-01, E-19, E-20 | ○ |
| C-22 | gui_cancel_drag()でドラッグをキャンセルできる | E-03 (3905-3910行の定義より) | ○ |
| C-23 | ドロップ成功時はgui.drag_successfulがtrueになる | E-03 (2415行) | ○ |
| C-24 | ドロップ先がない場合はgui.drag_successfulがfalseになる | E-03 (2417行) | ○ |
| C-25 | セクションルートビューポートを起点として伝播する | E-03 (2426行), E-04 | ○ |
| C-26 | テストコードでもNOTIFICATION_DRAG_ENDの受信が確認されている | E-18 | ○ |
| C-27 | Viewport.gui_is_dragging()がポーリング代替手段である | E-08 (197-199行) | ○ |
| C-28 | 通知はペイロードを持たない（intのみ） | E-04 (1335行のnotification呼び出し) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張について根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードまたは公式ドキュメントで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] E-03のgui_perform_drop_at()実装とドキュメントの記述が一致しているか確認
- [ ] E-04の_propagate_drag_notification()の再帰ロジックが正しく説明されているか確認
- [ ] E-10〜E-18の各実装例が設計書の「受信側実装パターン」と整合しているか確認
- [ ] NOTIFICATION_DRAG_BEGINとの対称性が正しく説明されているか確認
