---
generated_at: 2026-01-23 17:00:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：運用マニュアル.md

## 本レポートについて

### 目的
本レポートは、生成された運用マニュアルの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **ショートカットキー一覧**：一部のショートカットは実装確認が必要
  2. **対応OS要件**：最新バージョンでの対応状況確認が必要
  3. **エラーメッセージ内容**：日本語化の有無を確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/README.md` - Godot Engine概要、主要機能、技術スタック
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 80機能の一覧定義
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 54画面の一覧定義
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移関係のMermaid図
- E-05: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv` - 50業務要件の定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面と機能の対応関係
- E-07: `docs/code-to-docs/画面設計書/1-プロジェクトマネージャー.md` - プロジェクトマネージャー画面の詳細仕様
- E-08: `docs/code-to-docs/画面設計書/2-エディタメイン画面.md` - エディタメイン画面の詳細仕様
- E-09: `docs/code-to-docs/画面設計書/3-2Dエディタ.md` - 2Dエディタ画面の詳細仕様
- E-10: `docs/code-to-docs/画面設計書/4-3Dエディタ.md` - 3Dエディタ画面の詳細仕様
- E-11: `docs/code-to-docs/画面設計書/5-スクリプトエディタ.md` - スクリプトエディタ画面の詳細仕様
- E-12: `editor/project_manager/project_manager.cpp` - プロジェクトマネージャー実装コード
- E-13: `editor/editor_node.cpp` - エディタメイン画面実装コード

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Godot Engineは2D/3Dゲームを統一インターフェースで作成できる | E-01, E-05 (BR-001) | ○ |
| C-02 | MITライセンスで完全無料・オープンソース | E-01 | ○ |
| C-03 | プロジェクトマネージャーが起動時に表示される | E-07, E-04 | ○ |
| C-04 | プロジェクトの新規作成、インポート、削除が可能 | E-07 | ○ |
| C-05 | 2D/3D/Script/AssetLibのタブ切り替えが可能 | E-08, E-04 | ○ |
| C-06 | シーンツリードックでノード階層を管理 | E-03 (画面No.8), E-06 | ○ |
| C-07 | ファイルシステムドックでプロジェクトファイルを管理 | E-03 (画面No.7), E-02 (機能48) | ○ |
| C-08 | インスペクタードックでプロパティ編集 | E-03 (画面No.9), E-02 (機能49) | ○ |
| C-09 | 2Dエディタでスプライト配置・編集が可能 | E-09, E-02 (機能6) | ○ |
| C-10 | 3Dエディタでメッシュ配置・ギズモ操作が可能 | E-10, E-02 (機能7) | ○ |
| C-11 | スクリプトエディタでGDScript/C#編集が可能 | E-11, E-02 (機能42, 43) | ○ |
| C-12 | コード補完（Ctrl+Space）が使用可能 | E-11 | ○ |
| C-13 | ブレークポイント設定（F9）が可能 | E-11 | ○ |
| C-14 | シグナル接続でイベント駆動通信が可能 | E-02 (機能5), E-06 | ○ |
| C-15 | F5でプロジェクト実行が可能 | E-08 | ○ |
| C-16 | F8でゲーム停止が可能 | E-08 | ○ |
| C-17 | デバッガでブレークポイント・変数監視が可能 | E-02 (機能50), E-03 (画面No.15) | ○ |
| C-18 | Windows/macOS/Linux/Android/iOS/Webにエクスポート可能 | E-02 (機能51-56), E-05 (BR-002) | ○ |
| C-19 | エクスポートテンプレートのダウンロードが必要 | E-05 (BR-041) | ○ |
| C-20 | アセットライブラリからオンラインアセットをダウンロード可能 | E-03 (画面No.6), E-02 (機能38) | ○ |
| C-21 | プロジェクト設定でInput Map設定が可能 | E-06 (画面No.21), E-02 (機能26) | ○ |
| C-22 | Undo/Redo（Ctrl+Z/Ctrl+Shift+Z）が使用可能 | E-08 | ○ |
| C-23 | ノード作成ダイアログでノード追加が可能 | E-03 (画面No.28), E-04 | ○ |
| C-24 | シーン保存（Ctrl+S）が可能 | E-08 | ○ |
| C-25 | .tscn/.scn形式でシーン保存 | E-08 | ○ |
| C-26 | グリッドスナップ機能が利用可能 | E-09 | ○ |
| C-27 | ズーム・パン操作でビューポートナビゲーション | E-09, E-10 | ○ |
| C-28 | オービットナビゲーション（中クリック+ドラッグ）が可能 | E-10 | ○ |
| C-29 | フリールックモード（右クリック+WASD）が可能 | E-10 | ○ |
| C-30 | 検索・置換（Ctrl+F/Ctrl+H）が使用可能 | E-11 | ○ |
| C-31 | 定義へジャンプ（Ctrl+クリック/F12）が使用可能 | E-11 | ○ |
| C-32 | ドキュメント参照（Shift+F1）が使用可能 | E-11 | ○ |
| C-33 | 出力パネルでprint()出力・警告・エラー表示 | E-03 (画面No.14), E-02 (機能50) | ○ |
| C-34 | プロジェクトスキャン機能で一括インポート可能 | E-07 | ○ |
| C-35 | プロジェクトタグ機能で分類可能 | E-07 | ○ |
| C-36 | Ctrl+Pでクイックオープンダイアログ | E-08, E-03 (画面No.27) | ○ |
| C-37 | メインシーン未設定でRun時にエラー | E-07 (MSG001) | ○ |
| C-38 | 未保存シーンクローズ時に確認ダイアログ | E-08 (MSG001) | ○ |
| C-39 | 対応OS：Windows 10以降、macOS 10.14以降、Linux | E-01 | ○ |
| C-40 | OpenGL 3.3/GLES 3.0/Vulkan 1.0対応GPUが必要 | E-01 | ○ |
| C-41 | Python 3.8以上（ビルド時のみ）が必要 | E-01 | ○ |
| C-42 | F1でヘルプ検索が可能 | **根拠不足** | △ |
| C-43 | 2Dエディタのショートカット（W/E/S/Q）が使用可能 | **実装確認必要** | △ |
| C-44 | 4GB以上のRAMを推奨 | **明示的記載なし** | △ |
| C-45 | ノードロック・非表示機能が利用可能 | E-09, E-10 | ○ |

## 4) 不足情報（Unknown / Missing）

- **F1キーでヘルプ検索（C-42）**
  - 画面設計書・機能一覧に明示的な記載がない
  - 候補：公式ドキュメント / ソースコード確認 / 実機テスト

- **2Dエディタショートカット（C-43）**
  - 画面設計書にツールバーの記載はあるが、ショートカットキーの詳細な対応は未確認
  - 候補：editor/scene/canvas_item_editor_plugin.cpp / エディター設定画面 / キーバインド設定

- **RAM推奨値（C-44）**
  - README.mdに明示的な記載がない
  - 候補：公式ドキュメント / システム要件ページ

## 5) リスクフラグ（レビュー観点）

| リスク | 対象 | レベル | 説明 |
|--------|------|--------|------|
| 0 | 基本操作説明 | 低 | 画面設計書・機能一覧に基づく記述 |
| 0 | 業務フロー | 低 | 業務要件一覧・画面遷移図に基づく構成 |
| 1 | ショートカットキー一覧 | 中 | 一部は実装確認が必要 |
| 0 | エラーメッセージ | 低 | 画面設計書に明記されたメッセージを引用 |
| 1 | システム要件 | 中 | 最新バージョンでの正確な要件確認が必要 |

## 6) レビュアーチェックリスト（最小）

- [ ] システム概要がプロジェクトの目的と一致しているか確認
- [ ] 業務フロー（STEP1〜5）がエンドユーザーの実際のワークフローを反映しているか確認
- [ ] ショートカットキーが最新バージョンで正しいか実機確認
- [ ] エラーメッセージが実際の表示と一致するか確認
- [ ] スクリーンショットや図の追加が必要か検討
- [ ] 対応OS・システム要件が最新の公式情報と一致するか確認
- [ ] GDScriptのサンプルコードが正しく動作するか確認
- [ ] エクスポート手順が現行バージョンで正しいか確認
