# Godot Engine 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [起動・終了手順](#2-起動終了手順)
3. [トップページ（プロジェクトマネージャー）](#3-トップページプロジェクトマネージャー)

**【業務フローに沿った機能】**
4. [【STEP1】プロジェクト管理（プロジェクトの作成・設定）](#4-step1プロジェクト管理プロジェクトの作成設定)
5. [【STEP2-3】シーン編集（2D/3Dシーンの構築）](#5-step2-3シーン編集2d3dシーンの構築)
6. [【STEP3-4】スクリプト編集（ゲームロジックの実装）](#6-step3-4スクリプト編集ゲームロジックの実装)
7. [【STEP4-5】テスト・エクスポート（ビルド・配布）](#7-step4-5テストエクスポートビルド配布)

**【サポート機能】**
8. [アセットライブラリ](#8-アセットライブラリ)
9. [デバッガ・出力パネル](#9-デバッガ出力パネル)
10. [ヘルプ・ドキュメント参照](#10-ヘルプドキュメント参照)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 Godot Engineとは

Godot Engineは、2Dおよび3Dゲームを統一インターフェースから作成できる、機能豊富なクロスプラットフォームゲームエンジンです。MITライセンスの下で完全に無料かつオープンソースで提供されており、ロイヤリティなしで商用・非商用を問わず利用できます。

ゲーム開発者やクリエイターが、シーン編集、スクリプティング、アセット管理といった多様なタスクをシームレスに切り替えながら作業できる統合開発環境を提供します。

### 1.2 本システムで行う主要業務

本システムは、主に以下の業務を支援します：

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **プロジェクト管理** | プロジェクトの作成、インポート、設定管理、エクスポート |
| **シーン構築** | 2D/3Dシーンの編集、ノード配置、階層構造管理 |
| **スクリプト開発** | GDScript/C#によるゲームロジック実装、デバッグ |
| **アセット管理** | テクスチャ、モデル、オーディオ等のインポート・管理 |
| **テスト・デバッグ** | ゲーム実行、ブレークポイント、変数監視 |
| **配布準備** | 各プラットフォーム向けエクスポート設定・ビルド |

### 1.3 業務フロー概要

本システムにおけるゲーム開発業務は、以下の流れで進行します：

```
┌─────────────────────────────────────────────────────────────────┐
│                     ゲーム開発業務フロー                          │
├─────────────────────────────────────────────────────────────────┤
│                                                                 │
│  【STEP 1】プロジェクトの作成・設定                              │
│      - プロジェクトマネージャーで新規プロジェクト作成             │
│      - プロジェクト設定（画面サイズ、入力マップ等）              │
│      ↓                                                          │
│  【STEP 2】シーン構築（2D/3Dエディタ）                           │
│      - ノードの配置・階層構造作成                                │
│      - シーンの保存・管理                                        │
│      ↓                                                          │
│  【STEP 3】スクリプト実装（スクリプトエディタ）                  │
│      - GDScript/C#でゲームロジック記述                           │
│      - シグナル接続・イベント処理                                │
│      ↓                                                          │
│  【STEP 4】テスト・デバッグ                                      │
│      - ゲーム実行・動作確認                                      │
│      - デバッガでバグ修正                                        │
│      ↓                                                          │
│  【STEP 5】エクスポート・配布                                    │
│      - 各プラットフォーム向けビルド設定                          │
│      - エクスポート実行・配布準備                                │
│                                                                 │
└─────────────────────────────────────────────────────────────────┘
```

**役割別の業務概要：**

| 役割 | 主な業務 |
|------|---------|
| **ゲームデザイナー** | シーン構築、ノード配置、レベルデザイン、UIデザイン |
| **プログラマー** | スクリプト実装、ゲームロジック開発、デバッグ |
| **アーティスト** | アセット作成・インポート、シェーダー編集 |
| **QAテスター** | ゲーム実行、バグ報告、動作検証 |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| プロジェクトマネージャー | プロジェクトの一覧管理・作成・インポート | STEP 1 |
| 2Dエディタ | 2Dノード・スプライトの配置・編集 | STEP 2 |
| 3Dエディタ | 3Dノード・メッシュの配置・編集 | STEP 2 |
| スクリプトエディタ | GDScript/C#コードの編集・デバッグ | STEP 3 |
| デバッガ | ブレークポイント・変数監視・プロファイリング | STEP 4 |
| エクスポート | 各プラットフォーム向けビルド | STEP 5 |
| アセットライブラリ | オンラインアセットの検索・ダウンロード | 随時利用 |
| ヘルプ | ドキュメント参照・クラスリファレンス | 随時参照 |

### 1.5 ユーザー種別

Godot Engineは単一のユーザータイプで動作します。全機能にフルアクセス可能です。

| ユーザー種別 | 説明 |
|-------------|------|
| 開発者 | すべての機能（編集、スクリプト、エクスポート等）を利用可能 |

### 1.6 対応ブラウザ/動作環境

Godot Engineはデスクトップアプリケーションです。

**対応OS：**
- Windows 10以降（64ビット）
- macOS 10.14以降
- Linux/BSD（64ビット）

**推奨環境：**
- OpenGL 3.3 / GLES 3.0 / Vulkan 1.0対応GPU
- 4GB以上のRAM
- Python 3.8以上（ビルド時のみ）

---

## 2. 起動・終了手順

### 2.1 起動方法

1. Godot Engineの実行ファイルをダブルクリックします
   - Windows: `Godot.exe`
   - macOS: `Godot.app`
   - Linux: `Godot.x86_64`

2. 「プロジェクトマネージャー」画面が表示されます

**起動オプション（コマンドライン）：**

| オプション | 説明 |
|-----------|------|
| `--project-manager` | プロジェクトマネージャーを強制的に開く |
| `--path <プロジェクトパス>` | 指定プロジェクトを直接開く |
| `--editor` | エディターモードで起動 |
| `--help` | ヘルプを表示 |

### 2.2 終了方法

#### プロジェクトマネージャーからの終了

1. ウィンドウ右上の「X」ボタンをクリックします
2. または、メニューから「Quit」を選択します

#### エディターからの終了

1. メニューバーの「Project」をクリックします
2. 「Quit」または「Quit to Project List」を選択します
3. 未保存の変更がある場合は確認ダイアログが表示されます

**確認ダイアログ：**

未保存のシーンがある場合：
> Save changes to 'シーン名' before closing?
> - 「Save」：保存してから終了
> - 「Don't Save」：保存せずに終了
> - 「Cancel」：終了をキャンセル

---

## 3. トップページ（プロジェクトマネージャー）

### 3.1 プロジェクトマネージャー画面

プロジェクトマネージャーは、Godot Engine起動時に最初に表示される画面です。ここでプロジェクトの管理を行います。

**画面構成：**

| エリア | 説明 |
|--------|------|
| ツールバー（上部） | 新規作成、インポート、スキャン、実行ボタン |
| 検索バー | プロジェクト名での絞り込み検索 |
| プロジェクト一覧（中央） | 登録済みプロジェクトの一覧表示 |
| タブ切り替え（上部右） | 「Local Projects」/「Asset Library」の切り替え |
| バージョン情報（下部） | Godotバージョン、About、設定ボタン |

**プロジェクト一覧の表示項目：**

| 項目 | 説明 |
|------|------|
| プロジェクトアイコン | サムネイル画像（icon.pngまたはデフォルト） |
| プロジェクト名 | project.godotで定義された名前 |
| プロジェクトパス | ファイルシステム上の場所 |
| Godotバージョン | 作成時のGodotバージョン |
| タグ | 分類用のラベル |
| ステータス | 正常/欠落/要変換 |

### 3.2 主要操作

#### プロジェクトを開く

1. プロジェクト一覧から対象プロジェクトをクリックして選択します
2. 「Edit」ボタンをクリック、またはプロジェクトをダブルクリックします
3. エディタメイン画面が開きます

#### プロジェクトを実行する

1. プロジェクト一覧から対象プロジェクトを選択します
2. 「Run」ボタンをクリックします
3. ゲームが別ウィンドウで起動します

**注意：** メインシーンが設定されていない場合はエラーメッセージが表示されます。

---

## 4. 【STEP1】プロジェクト管理（プロジェクトの作成・設定）

> **業務フローでの位置**: ゲーム開発の最初のステップとして、プロジェクトの作成と基本設定を行います。

### 4.1 新規プロジェクトを作成する

1. プロジェクトマネージャーで「New」ボタンをクリックします
2. プロジェクトダイアログが表示されます
3. 以下の項目を入力します：

| 項目 | 説明 | 必須 |
|------|------|------|
| Project Name | プロジェクト名（日本語可） | 必須 |
| Project Path | 保存先ディレクトリ | 必須 |
| Renderer | Mobile（推奨）/ Forward+（高品質）/ Compatibility（旧ハード対応） | 必須 |

4. 「Create & Edit」ボタンをクリックします
5. エディタメイン画面が開きます

**Tips：**
- プロジェクト名にはスペースや日本語も使用可能です
- プロジェクトパスは空のフォルダを選択してください

### 4.2 既存プロジェクトをインポートする

#### ZIPファイルからインポート

1. 「Import」ボタンをクリックします
2. ファイルダイアログで`.zip`ファイルを選択します
3. 展開先ディレクトリを指定します
4. 「Import & Edit」をクリックします

#### ディレクトリからインポート

1. 「Import」ボタンをクリックします
2. `project.godot`ファイルを含むディレクトリを選択します
3. 「Import & Edit」をクリックします

### 4.3 プロジェクトをスキャンする

複数のプロジェクトを一括で追加できます：

1. 「Scan」ボタンをクリックします
2. スキャン対象のディレクトリを選択します
3. 自動的にサブディレクトリ内のプロジェクトが検出され、一覧に追加されます

### 4.4 プロジェクト設定を編集する

1. エディタメイン画面で「Project」メニューをクリックします
2. 「Project Settings...」を選択します（ショートカット：なし）
3. プロジェクト設定ダイアログが開きます

**主要な設定項目：**

| タブ | 設定内容 |
|------|---------|
| General | プロジェクト名、説明、アイコン、画面サイズ |
| Input Map | キーバインド、アクション設定 |
| Autoload | 自動読み込みスクリプト/シーン |
| Localization | 多言語対応設定 |
| Shader Globals | グローバルシェーダー変数 |

**画面サイズの設定例：**

1. 「General」タブで検索欄に「window」と入力
2. 「Display > Window」セクションを展開
3. 「Size > Viewport Width/Height」を設定

### 4.5 プロジェクトを削除する

1. プロジェクト一覧で対象プロジェクトを選択します
2. 「Remove」ボタンをクリックします
3. 確認ダイアログで「Remove」をクリックします

**注意：** この操作はプロジェクトを一覧から削除するだけで、ファイルシステム上のファイルは削除されません。

---

## 5. 【STEP2-3】シーン編集（2D/3Dシーンの構築）

> **業務フローでの位置**: プロジェクト作成後、ゲームのビジュアル要素（キャラクター、背景、UI等）を配置してシーンを構築します。

### 5.1 エディタメイン画面の構成

エディタメイン画面は以下のエリアで構成されています：

| エリア | 位置 | 説明 |
|--------|------|------|
| メインエディタタブ | 上部中央 | 2D/3D/Script/AssetLibの切り替え |
| シーンタブ | 上部 | 開いているシーンのタブ一覧 |
| シーンツリードック | 左側 | ノード階層の表示・編集 |
| ファイルシステムドック | 左下 | プロジェクトファイル一覧 |
| インスペクタードック | 右側 | 選択ノードのプロパティ編集 |
| ビューポート | 中央 | 2D/3Dシーンの描画領域 |
| ボトムパネル | 下部 | 出力、デバッガ、アニメーション等 |

### 5.2 新しいシーンを作成する

1. 「Scene」メニューから「New Scene」を選択します（Ctrl+N）
2. シーン作成ダイアログでルートノードタイプを選択します：

| ルートタイプ | 用途 |
|-------------|------|
| 2D Scene | 2Dゲーム用（Node2Dがルート） |
| 3D Scene | 3Dゲーム用（Node3Dがルート） |
| User Interface | UIシーン用（Controlがルート） |
| Other Node | 任意のノードを選択 |

3. 選択後、空のシーンが作成されます

### 5.3 ノードを追加する

1. シーンツリードックで親ノードを選択します
2. 「+」ボタンをクリック、またはCtrl+Aを押します
3. ノード作成ダイアログが開きます
4. 検索欄でノード名を入力して絞り込みます
5. 目的のノードを選択して「Create」をクリックします

**よく使用するノード：**

| ノード | 説明 |
|--------|------|
| Sprite2D | 2D画像表示 |
| CharacterBody2D | 2Dキャラクター（物理対応） |
| Camera2D | 2Dカメラ |
| MeshInstance3D | 3Dメッシュ表示 |
| Camera3D | 3Dカメラ |
| DirectionalLight3D | 平行光源 |
| Button | UIボタン |
| Label | テキスト表示 |

### 5.4 2Dエディタでの操作

#### ノードの選択と移動

1. 「2D」タブをクリックして2Dエディタに切り替えます（F1キー）
2. ビューポート上でノードをクリックして選択します
3. ドラッグして移動します

**便利なショートカット：**

| 操作 | ショートカット |
|------|---------------|
| 移動ツール | W |
| 回転ツール | E |
| スケールツール | S |
| 選択ツール | Q |
| グリッドスナップ切替 | G |
| 複製 | Ctrl+D |
| 削除 | Delete |

#### ビューポートのナビゲーション

| 操作 | 方法 |
|------|------|
| パン（スクロール） | 中クリック+ドラッグ、またはスペース+ドラッグ |
| ズーム | マウスホイール |
| リセット | Ctrl+0 |

### 5.5 3Dエディタでの操作

#### ノードの選択と変形

1. 「3D」タブをクリックして3Dエディタに切り替えます（F2キー）
2. ビューポート上でノードをクリックして選択します
3. ギズモ（矢印/リング/ボックス）をドラッグして変形します

**ギズモ操作：**

| ギズモ | 操作 |
|--------|------|
| 矢印（軸） | 軸方向への移動 |
| リング | 軸周りの回転 |
| ボックス | 軸方向へのスケール |
| 中央 | 自由移動/均等スケール |

#### ビューポートのナビゲーション

| 操作 | 方法 |
|------|------|
| オービット（回転） | 中クリック+ドラッグ |
| パン | Shift+中クリック+ドラッグ |
| ズーム | マウスホイール |
| フリールック | 右クリック長押し+WASD |

### 5.6 シーンを保存する

1. 「Scene」メニューから「Save Scene」を選択します（Ctrl+S）
2. 初回保存時は保存先とファイル名を指定します
3. 拡張子は`.tscn`（テキスト形式）または`.scn`（バイナリ形式）

**Tips：**
- こまめな保存を心がけてください
- 未保存のシーンにはタブに「*」マークが表示されます

---

## 6. 【STEP3-4】スクリプト編集（ゲームロジックの実装）

> **業務フローでの位置**: シーン構築後、ノードにスクリプトをアタッチしてゲームロジック（動き、入力処理、ゲームルール等）を実装します。

### 6.1 スクリプトを作成してアタッチする

1. シーンツリードックでスクリプトをアタッチするノードを選択します
2. 右クリックして「Attach Script」を選択、またはスクリプトアイコンをクリックします
3. スクリプト作成ダイアログが開きます
4. 以下を設定します：

| 項目 | 説明 |
|------|------|
| Language | GDScript（推奨）/ C# |
| Inherits | 継承元クラス（自動設定） |
| Template | テンプレート（Default/Empty） |
| Path | 保存先パス |

5. 「Create」をクリックします
6. スクリプトエディタが開きます

### 6.2 スクリプトエディタの操作

#### 基本的なコード編集

- 「Script」タブをクリックしてスクリプトエディタに切り替えます（F3キー）
- 左側にスクリプトタブ一覧、中央にコードエリアが表示されます

**便利なショートカット：**

| 操作 | ショートカット |
|------|---------------|
| コード補完 | Ctrl+Space |
| 保存 | Ctrl+S |
| 検索 | Ctrl+F |
| 置換 | Ctrl+H |
| 定義へジャンプ | Ctrl+クリック、F12 |
| ドキュメント参照 | Shift+F1 |
| ブレークポイント設定 | F9 |

#### コード補完

入力中に自動でコード補完候補が表示されます。
- 矢印キーで選択
- EnterまたはTabで確定
- Escでキャンセル

### 6.3 GDScriptの基本

GDScriptはPythonに似た独自スクリプト言語です。

**基本的なスクリプト構造：**

```gdscript
extends Node2D

# 変数宣言
var speed = 200.0
@export var health = 100  # インスペクターに表示

# シーン開始時に呼ばれる
func _ready():
    print("Hello, Godot!")

# 毎フレーム呼ばれる
func _process(delta):
    position.x += speed * delta

# 入力イベント
func _input(event):
    if event.is_action_pressed("ui_accept"):
        print("Accept pressed!")
```

### 6.4 シグナル（イベント）を接続する

シグナルはノード間のイベント通信機構です。

#### エディタで接続する方法

1. シグナルを発信するノードを選択します
2. 「シグナルドック」タブをクリックします（インスペクターの隣）
3. 接続したいシグナルをダブルクリックします
4. 接続ダイアログで受信するノードとメソッドを選択します
5. 「Connect」をクリックします

#### コードで接続する方法

```gdscript
func _ready():
    # $Buttonは子ノード「Button」への参照
    $Button.pressed.connect(_on_button_pressed)

func _on_button_pressed():
    print("Button was pressed!")
```

---

## 7. 【STEP4-5】テスト・エクスポート（ビルド・配布）

> **業務フローでの位置**: スクリプト実装後、ゲームを実行してテスト・デバッグし、最終的に各プラットフォーム向けにエクスポートして配布準備を行います。

### 7.1 ゲームを実行する

#### プロジェクト全体を実行

1. ツールバーの「Play」ボタンをクリックします（F5）
2. メインシーンが実行されます

**注意：** メインシーンが未設定の場合はダイアログが表示されます。その場合：
1. 「Select」をクリック
2. メインシーンファイルを選択
3. 「Open」をクリック

#### 現在のシーンを実行

1. ツールバーの「Play Current Scene」ボタンをクリックします（F6）
2. 現在編集中のシーンが実行されます

#### ゲームを停止

1. ツールバーの「Stop」ボタンをクリックします（F8）
2. またはゲームウィンドウを閉じます

### 7.2 デバッガを使用する

#### ブレークポイントの設定

1. スクリプトエディタで停止したい行の行番号をクリックします
2. または、その行にカーソルを置いてF9を押します
3. 赤い丸印が表示されます

#### デバッグ実行

1. ブレークポイントを設定した状態でゲームを実行します
2. ブレークポイントで実行が停止します
3. デバッガパネルで以下を確認できます：

| タブ | 内容 |
|------|------|
| Stack Frames | コールスタック |
| Locals | ローカル変数の値 |
| Members | クラスメンバーの値 |
| Globals | グローバル変数の値 |

#### ステップ実行

| 操作 | ショートカット | 説明 |
|------|---------------|------|
| Continue | F12 | 実行を再開 |
| Step Into | F11 | 関数内に入る |
| Step Over | F10 | 次の行へ |
| Break | - | 実行を中断 |

### 7.3 エクスポートの準備

#### エクスポートテンプレートのインストール

初回エクスポート時にテンプレートが必要です：

1. 「Editor」メニューから「Manage Export Templates...」を選択します
2. 「Download and Install」をクリックします
3. ダウンロードが完了するまで待ちます

### 7.4 プロジェクトをエクスポートする

1. 「Project」メニューから「Export...」を選択します
2. エクスポートダイアログが開きます
3. 「Add...」をクリックしてプリセットを追加します

**対応プラットフォーム：**

| プラットフォーム | 説明 |
|-----------------|------|
| Windows Desktop | Windows PC向け |
| macOS | Mac向け |
| Linux/X11 | Linux向け |
| Android | Android端末向け |
| iOS | iPhone/iPad向け |
| Web | ブラウザ向け（WebAssembly） |

4. プリセットを選択して設定を行います
5. 「Export Project」をクリックします
6. 保存先とファイル名を指定します
7. 「Save」をクリックしてエクスポートを実行します

---

## 8. アセットライブラリ

### 8.1 アセットライブラリにアクセスする

1. エディタメイン画面上部の「AssetLib」タブをクリックします（F4）
2. または、プロジェクトマネージャーで「Asset Library」タブを選択します

### 8.2 アセットを検索する

1. 検索欄にキーワードを入力します
2. カテゴリやソートで絞り込みます：
   - カテゴリ：2D Assets、3D Assets、Tools、Scripts等
   - ソート：Updated、Name、Downloads、Rating

### 8.3 アセットをインストールする

1. 目的のアセットをクリックして詳細を表示します
2. 「Download」ボタンをクリックします
3. ダウンロード完了後、「Install」ボタンをクリックします
4. インストーラーダイアログでファイルを確認します
5. 「Install」をクリックしてプロジェクトに追加します

---

## 9. デバッガ・出力パネル

### 9.1 出力パネル

ゲーム実行中のprint()出力、警告、エラーを表示します。

**アクセス方法：**
- ボトムパネルの「Output」タブをクリック

**表示内容：**

| アイコン | 意味 |
|---------|------|
| 青 | print()出力 |
| 黄 | 警告（Warning） |
| 赤 | エラー（Error） |

**操作：**
- 「Clear」でログをクリア
- エラー行をクリックでスクリプトエディタへジャンプ

### 9.2 デバッガパネル

ブレークポイント停止時に詳細情報を表示します。

**タブ構成：**

| タブ | 説明 |
|------|------|
| Errors | エラーと警告の一覧 |
| Profiler | パフォーマンス計測 |
| Visual Profiler | GPUパフォーマンス |
| Monitors | FPS、メモリ使用量等 |

---

## 10. ヘルプ・ドキュメント参照

### 10.1 クラスリファレンスを開く

1. 「Help」メニューから「Search Help」を選択します（F1）
2. クラス名を検索します
3. 結果をクリックしてドキュメントを表示します

### 10.2 コンテキストヘルプ

スクリプトエディタで：
1. クラス名やメソッド名にカーソルを置きます
2. Shift+F1を押します
3. 該当するドキュメントが表示されます

### 10.3 オンラインドキュメント

1. 「Help」メニューから「Online Documentation」を選択します
2. ブラウザで公式ドキュメントが開きます

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
業務フロー概要（再掲）
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
【STEP 1】プロジェクトの作成・設定 → 4章参照
    ↓
【STEP 2】シーン構築（2D/3Dエディタ） → 5章参照
    ↓
【STEP 3】スクリプト実装（スクリプトエディタ） → 6章参照
    ↓
【STEP 4】テスト・デバッグ → 7章参照
    ↓
【STEP 5】エクスポート・配布 → 7章参照
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

### 11.1 【開発者】STEP1: プロジェクトの準備

新しいゲーム開発を開始する際は、まずプロジェクトを作成します。

1. Godot Engineを起動します
2. プロジェクトマネージャーで「New」をクリックします
3. プロジェクト名と保存場所を設定します
4. レンダラーを選択して「Create & Edit」をクリックします
5. エディターが開いたら「Project > Project Settings」でプロジェクト設定を行います

### 11.2 【開発者】STEP2: シーンの構築

ゲームの各画面（タイトル、ゲームプレイ、リザルト等）をシーンとして作成します。

1. 「Scene > New Scene」で新規シーンを作成します
2. ルートノードタイプを選択します（2D/3D/UI）
3. シーンツリードックで「+」ボタンをクリックしてノードを追加します
4. ビューポートでノードを配置・調整します
5. 「Ctrl+S」でシーンを保存します

### 11.3 【開発者】STEP3: スクリプトの実装

ゲームロジックをスクリプトで実装します。

1. スクリプトをアタッチするノードを選択します
2. 右クリックして「Attach Script」を選択します
3. スクリプトを作成して「Script」タブで編集します
4. 必要に応じてシグナルを接続します
5. 「Ctrl+S」でスクリプトを保存します

### 11.4 【開発者】STEP4-5: テストとエクスポート

作成したゲームをテストし、問題がなければエクスポートします。

1. 「F5」でゲームを実行してテストします
2. 問題があればデバッガで調査・修正します
3. 「Project > Export」でエクスポートダイアログを開きます
4. 対象プラットフォームのプリセットを追加します
5. 「Export Project」でビルドを実行します

---

## 12. よくある質問と対処法

### 12.1 起動・プロジェクト関連

**Q: プロジェクトマネージャーにプロジェクトが表示されません**

A: 以下を確認してください：
- 「Import」ボタンでプロジェクトを手動で追加してください
- 「Scan」ボタンでプロジェクトを検索してください
- プロジェクトフォルダに`project.godot`ファイルが存在することを確認してください

**Q: 古いバージョンのプロジェクトが開けません**

A: 以下を確認してください：
- Godot 3.xのプロジェクトはGodot 4.xでは直接開けません
- 変換ツールを使用するか、手動で移行作業が必要です
- バージョン互換性についてはドキュメントを参照してください

### 12.2 編集・操作関連

**Q: ノードが選択できません**

A: 以下を確認してください：
- ノードがロックされていないか確認（シーンツリーの鍵アイコン）
- ノードが表示状態か確認（シーンツリーの目のアイコン）
- ツールバーで正しいツールが選択されているか確認

**Q: 操作を間違えてしまいました**

A: 「Edit > Undo」（Ctrl+Z）で操作を取り消せます。

### 12.3 スクリプト関連

**Q: スクリプトでエラーが出ます**

A: 以下を確認してください：
- 出力パネルでエラーメッセージを確認
- エラー行のクリックでスクリプトにジャンプ
- シンタックス（インデント、コロン、括弧）を確認

**Q: コード補完が動きません**

A: 以下を試してください：
- Ctrl+Spaceで手動起動
- エディター設定で補完設定を確認
- スクリプトを保存してリロード

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| Can't run project: Project has no main scene defined. | メインシーンが未設定 | Project Settings > Application > Run > Main Sceneを設定 |
| Can't open scene file '%s'. | シーンファイル破損または欠落 | バックアップから復元、またはファイル存在を確認 |
| Parse Error: Expected ... | GDScript構文エラー | エラー行を確認し、構文を修正 |
| Cannot call method on a null value | nullオブジェクトへのアクセス | ノードパスやインスタンスの存在を確認 |

### 13.2 よくあるトラブルと解決方法

**トラブル：ゲームが真っ暗で何も表示されない**

解決方法：
1. Camera2D/Camera3Dノードが存在するか確認
2. カメラの「Current」プロパティがオンになっているか確認
3. ライト（3Dの場合）が設置されているか確認
4. ノードのVisibleプロパティがオンになっているか確認

**トラブル：エクスポートに失敗する**

解決方法：
1. エクスポートテンプレートがインストールされているか確認
2. 出力先に書き込み権限があるか確認
3. プロジェクトにエラーがないか確認（全シーンを開いてみる）

**トラブル：エディターが重い/フリーズする**

解決方法：
1. 大きなアセット（高解像度テクスチャ等）がないか確認
2. Editor > Editor Settingsでパフォーマンス設定を調整
3. Godotを再起動
4. プロジェクトを再インポート（.godotフォルダを削除して再起動）

### 13.3 サポートへの連絡方法

**公式リソース：**
- 公式ドキュメント: https://docs.godotengine.org
- 公式フォーラム: https://forum.godotengine.org
- GitHub Issues: https://github.com/godotengine/godot/issues
- Discord: Godot Engine公式サーバー

**バグ報告時に必要な情報：**
- Godotのバージョン
- OS情報
- 再現手順
- エラーメッセージ（ある場合）
- スクリーンショット（必要に応じて）

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-01-23 | 初版作成 |

---

*本マニュアルは、Godot Engineのエンドユーザー向け業務運用マニュアルです。*
*システムの更新により、画面や操作方法が変更される場合があります。*
