---
generated_at: 2026-01-23 17:30:00
metrics:
  claims_total: 50
  claims_with_evidence: 46
  claims_without_evidence: 4
confidence_derived: 0.92
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：46 / 50、根拠なし：4
- 優先レビュー（高）
  1. **NFT-027 クラッシュ後再起動復旧テスト**：復旧時間の具体的な計測基準が不明確
  2. **NFT-006 メモリアライメント検証テスト**：具体的なテスト方法の詳細が不足
  3. **NFT-007 PagedArrayメモリ効率テスト**：フラグメンテーション許容範囲の定義が不明確
  4. **NFT-020 鍵データゼロ化テスト**：検証方法の具体的手順が不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/非機能要件定義書/非機能要件定義書.md`
- E-02: `docs/code-to-docs/テスト方針書/テスト方針書.md`
- E-03: `docs/code-to-docs/セキュリティ設計書/セキュリティ設計書.md`
- E-04: `docs/code-to-docs/インフラ設計書/インフラ設計書.md`
- E-05: `docs/code-to-docs/アーキテクチャ設計書/アーキテクチャ設計書.md`
- E-06: `core/profiling/profiling.h`
- E-07: `tests/core/threads/test_worker_thread_pool.h`
- E-08: `tests/core/test_crypto.h`
- E-09: `tests/core/test_hashing_context.h`
- E-10: `modules/mbedtls/tests/test_crypto_mbedtls.cpp`
- E-11: `platform/linuxbsd/detect.py`
- E-12: `platform/macos/detect.py`
- E-13: `platform/windows/detect.py`
- E-14: `platform/web/detect.py`
- E-15: `.pre-commit-config.yaml`
- E-16: `SConstruct`
- E-17: `misc/error_suppressions/` (asan.txt, lsan.txt, tsan.txt, ubsan.txt)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NFT-001 フレームレンダリング60fps性能テスト | E-01, E-06 | ○ |
| C-02 | NFT-002 フレームレンダリング30fps性能テスト | E-01 | ○ |
| C-03 | NFT-003 WorkerThreadPool並列タスク処理テスト | E-01, E-07 | ○ |
| C-04 | NFT-004 WorkerThreadPoolグループタスク処理テスト | E-07 | ○ |
| C-05 | NFT-005 ワーカースレッドYield動作テスト | E-07 | ○ |
| C-06 | NFT-006 メモリアライメント検証テスト | E-01 | △ |
| C-07 | NFT-007 PagedArrayメモリ効率テスト | E-01 | △ |
| C-08 | NFT-008 AES-256ファイル暗号化テスト | E-01, E-03 | ○ |
| C-09 | NFT-009 ハッシュ計算（MD5）テスト | E-03, E-09 | ○ |
| C-10 | NFT-010 ハッシュ計算（SHA1）テスト | E-03, E-09 | ○ |
| C-11 | NFT-011 ハッシュ計算（SHA256）テスト | E-03, E-09 | ○ |
| C-12 | NFT-012 HMAC認証テスト | E-03, E-10 | ○ |
| C-13 | NFT-013 定数時間比較テスト | E-03, E-08 | ○ |
| C-14 | NFT-014 RSA鍵生成・保存テスト | E-03, E-10 | ○ |
| C-15 | NFT-015 X.509証明書テスト | E-03 | ○ |
| C-16 | NFT-016 TLSクライアント接続テスト | E-03 | ○ |
| C-17 | NFT-017 DTLSパケット暗号化テスト | E-03 | ○ |
| C-18 | NFT-018 パストラバーサル対策テスト | E-03 | ○ |
| C-19 | NFT-019 暗号学的乱数生成テスト | E-03 | ○ |
| C-20 | NFT-020 鍵データゼロ化テスト | E-03 | △ |
| C-21 | NFT-021 ファイル不存在エラー処理テスト | E-01 | ○ |
| C-22 | NFT-022 ファイルアクセス権限エラー処理テスト | E-01 | ○ |
| C-23 | NFT-023 メモリ不足エラー処理テスト | E-01 | ○ |
| C-24 | NFT-024 タイムアウトエラー処理テスト | E-01 | ○ |
| C-25 | NFT-025 ファイルロガーローテーションテスト | E-01 | ○ |
| C-26 | NFT-026 複合ロガー動作テスト | E-01 | ○ |
| C-27 | NFT-027 クラッシュ後再起動復旧テスト | E-01 | △ |
| C-28 | NFT-028 Windows互換性テスト | E-04, E-13 | ○ |
| C-29 | NFT-029 macOS互換性テスト | E-04, E-12 | ○ |
| C-30 | NFT-030 Linux互換性テスト | E-04, E-11 | ○ |
| C-31 | NFT-031 Web互換性テスト | E-04, E-14 | ○ |
| C-32 | NFT-032 x86_64アーキテクチャテスト | E-01 | ○ |
| C-33 | NFT-033 arm64アーキテクチャテスト | E-01 | ○ |
| C-34 | NFT-034 Vulkanバックエンドテスト | E-01, E-05 | ○ |
| C-35 | NFT-035 OpenGL ES 3.0バックエンドテスト | E-01, E-05 | ○ |
| C-36 | NFT-036 AddressSanitizer検証テスト | E-02, E-11, E-17 | ○ |
| C-37 | NFT-037 UndefinedBehaviorSanitizer検証テスト | E-02, E-11, E-17 | ○ |
| C-38 | NFT-038 ThreadSanitizer検証テスト | E-02, E-11, E-17 | ○ |
| C-39 | NFT-039 LeakSanitizer検証テスト | E-02, E-11, E-17 | ○ |
| C-40 | NFT-040 clang-tidyスタティック解析テスト | E-02, E-15 | ○ |
| C-41 | NFT-041 コードスペルチェックテスト | E-02, E-15 | ○ |
| C-42 | NFT-042 SConsビルドシステムテスト | E-01, E-16 | ○ |
| C-43 | NFT-043 並列ビルドテスト | E-01, E-16 | ○ |
| C-44 | NFT-044 SCUビルドテスト | E-04, E-16 | ○ |
| C-45 | NFT-045 doctest単体テスト実行テスト | E-02 | ○ |
| C-46 | NFT-046 GDScriptランタイムテスト | E-02 | ○ |
| C-47 | NFT-047 デバッグシンボル生成テスト | E-01 | ○ |
| C-48 | NFT-048 Tracyプロファイラ連携テスト | E-01, E-06 | ○ |
| C-49 | NFT-049 Perfettoプロファイラ連携テスト | E-01, E-06 | ○ |
| C-50 | NFT-050 Apple Instrumentsプロファイラ連携テスト | E-01, E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-06 メモリアライメント検証テスト**：具体的なテスト実装コードが見つからない
  - 候補：tests/core/templates/test_local_vector.h / tests/core/templates/test_fixed_vector.h / 新規テスト作成
- **C-07 PagedArrayメモリ効率テスト**：フラグメンテーション許容範囲の具体的な数値基準が未定義
  - 候補：非機能要件定義書への追記 / ベンチマーク基準の明文化
- **C-20 鍵データゼロ化テスト**：mbedtls_platform_zeroize()の動作検証方法が不明確
  - 候補：メモリダンプ検証 / セキュリティ監査ツールの利用
- **C-27 クラッシュ後再起動復旧テスト**：「即時」の具体的な数値基準が未定義
  - 候補：復旧時間の上限値定義（例：5秒以内）

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - NFT-006, NFT-007：メモリ関連テストの合格基準が曖昧なため、テスト実行時の判定に主観が入る可能性
- **1: 中リスク** - NFT-020：セキュリティ上重要なテストだが、検証方法の具体性が不足
- **1: 中リスク** - NFT-027：可用性要件だが、具体的な復旧時間目標が未設定
- **0: 低リスク** - 大部分のテストケースは既存のドキュメント・コードから明確な根拠を持つ

## 6) レビュアーチェックリスト（最小）
- [ ] 性能テスト（NFT-001〜007）の合格基準値は実行環境に適切か
- [ ] セキュリティテスト（NFT-008〜020）は最新のセキュリティ要件を反映しているか
- [ ] 互換性テスト（NFT-028〜035）は全対象プラットフォームを網羅しているか
- [ ] サニタイザーテスト（NFT-036〜039）の抑制リスト（misc/error_suppressions/）は適切に管理されているか
- [ ] プロファイリングテスト（NFT-048〜050）は利用可能な全プロファイラを網羅しているか
- [ ] 根拠なし（△）のテストケースについて、追加調査または基準の明確化が必要か確認
