---
generated_at: 2026-01-23 17:00:00
metrics:
  claims_total: 52
  claims_with_evidence: 48
  claims_without_evidence: 4
confidence_derived: 0.92
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：48 / 52、根拠なし：4
- 優先レビュー（高）
  1. **フレームレンダリング目標値**：具体的な数値目標の根拠不足（業界標準値を採用）
  2. **物理シミュレーションタイムステップ**：推奨値の根拠確認が必要
  3. **RTO/RPO値**：スタンドアロンアプリケーションのため一般的な定義
  4. **ログバックアップ最大ファイル数**：デフォルト値の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `SConstruct` - ビルド設定・最適化オプション・プラットフォーム対応
- E-02: `version.py` - バージョン情報（4.6.0）
- E-03: `core/os/thread.h` - スレッドシステム・優先度・キャッシュライン
- E-04: `core/os/memory.h` - メモリ管理・アライメント・アロケータ
- E-05: `core/crypto/crypto.h` - 暗号化機能・TLS・HMAC・X.509
- E-06: `core/io/file_access_encrypted.h` - ファイル暗号化（AES-256）
- E-07: `core/object/worker_thread_pool.h` - ワーカースレッドプール・タスク管理
- E-08: `core/io/resource_loader.h` - リソースローダー・キャッシュモード
- E-09: `core/profiling/profiling.h` - プロファイリング機能（Tracy/Perfetto/Instruments）
- E-10: `core/io/logger.h` - ロギングシステム・ローテーション
- E-11: `core/os/os.h` - OS抽象化・省電力モード・ベンチマーク
- E-12: `core/error/error_list.h` - エラーコード定義
- E-13: `platform/*/detect.py` - プラットフォーム検出スクリプト群

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Godot Engine 4.6.0 | E-02 | ○ |
| C-02 | ワーカースレッド数=CPU論理コア数-1 | E-01, E-07 | ○ |
| C-03 | 低優先度タスク比率30% | E-07 (init関数) | ○ |
| C-04 | タスクページサイズ1024 | E-07 | ○ |
| C-05 | グループページサイズ256 | E-07 | ○ |
| C-06 | キャッシュラインサイズ128バイト | E-03 | ○ |
| C-07 | メモリアライメントmax_align_t | E-04 | ○ |
| C-08 | MinGW 32bit時16バイト固定 | E-04 | ○ |
| C-09 | CACHE_MODE_REUSEデフォルト | E-08 | ○ |
| C-10 | 最適化レベル（speed=-O3等） | E-01 | ○ |
| C-11 | AES-256ファイル暗号化 | E-06 | ○ |
| C-12 | mbedTLS TLS/SSL | E-01 (builtin_mbedtls) | ○ |
| C-13 | ハッシュ計算（MD5,SHA1,SHA256） | E-05 | ○ |
| C-14 | HMAC認証機能 | E-05 | ○ |
| C-15 | RSA暗号化・署名 | E-05 | ○ |
| C-16 | X.509証明書対応 | E-05 | ○ |
| C-17 | TLSオプション3モード | E-05 | ○ |
| C-18 | constant_time_compare | E-05 | ○ |
| C-19 | generate_random_bytes | E-05 | ○ |
| C-20 | OS::get_entropy | E-11 | ○ |
| C-21 | get_system_ca_certificates | E-11 | ○ |
| C-22 | Windows対応 | E-13 | ○ |
| C-23 | macOS対応 | E-13 | ○ |
| C-24 | Linux/BSD対応 | E-13 | ○ |
| C-25 | Android対応 | E-13 | ○ |
| C-26 | iOS対応 | E-13 | ○ |
| C-27 | visionOS対応 | E-13 | ○ |
| C-28 | Web対応 | E-13 | ○ |
| C-29 | Vulkanバックエンド | E-01 | ○ |
| C-30 | OpenGL ES 3.0/GLES3 | E-01 | ○ |
| C-31 | Direct3D 12 | E-01 | ○ |
| C-32 | Metal | E-01 | ○ |
| C-33 | モジュールシステム | E-01 | ○ |
| C-34 | GDExtension | E-01 (modules) | ○ |
| C-35 | x86_64 SSE4.2最適化 | E-01 | ○ |
| C-36 | x86_32 SSE2最適化 | E-01 | ○ |
| C-37 | C++17必須 | E-01 | ○ |
| C-38 | GCC 9+必須 | E-01 | ○ |
| C-39 | 例外処理デフォルト無効 | E-01 | ○ |
| C-40 | SCons 4.0以上必須 | E-01 | ○ |
| C-41 | ニンジャ対応 | E-01 | ○ |
| C-42 | Tracy対応 | E-09 | ○ |
| C-43 | Perfetto対応 | E-09 | ○ |
| C-44 | Instruments対応 | E-09 | ○ |
| C-45 | GodotProfileFrameMark | E-09 | ○ |
| C-46 | GodotProfileZone | E-09 | ○ |
| C-47 | GodotProfileAlloc/Free | E-09 | ○ |
| C-48 | 低プロセッサ使用モード | E-11 | ○ |
| C-49 | フレームレンダリング16.67ms | **根拠なし** | △ |
| C-50 | 物理シミュレーション60Hz推奨 | **根拠なし** | △ |
| C-51 | RTO即時・RPO最終保存時点 | **根拠なし** | △ |
| C-52 | ログバックアップ最大10ファイル | E-10 (RotatedFileLogger) | ○ |

## 4) 不足情報（Unknown / Missing）
- **フレームレンダリング目標値（C-49）**：コード内に明示的な目標値定義なし。60fps=16.67msは業界標準値であり、ゲームエンジンとしての一般的な目標値を記載
  - 候補：ProjectSettings内のフレームレート設定 / Engine::get_frames_per_second() / 公式ドキュメント

- **物理シミュレーション推奨値（C-50）**：物理エンジン設定ファイルまたは物理サーバー初期化コードの確認が必要
  - 候補：PhysicsServer2D/3D設定 / ProjectSettings / 公式ドキュメント

- **RTO/RPO定義（C-51）**：スタンドアロンアプリケーションのため、サーバーサイドの可用性要件とは異なる。一般的な解釈を記載
  - 候補：クラッシュハンドラ実装 / 自動保存機能 / プロジェクト設定

- **ログバックアップ数（C-52）**：RotatedFileLoggerのコンストラクタでデフォルト値10を確認済み

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**：プラットフォーム対応、レンダリングバックエンド、暗号化機能 - コードから明確に確認可能
- **0 (低リスク)**：ビルドオプション、最適化レベル - SConstructから直接確認
- **0 (低リスク)**：プロファイリング機能 - マクロ定義から確認
- **1 (中リスク)**：性能目標値 - 業界標準値を採用しているが、プロジェクト固有の目標確認が必要
- **1 (中リスク)**：可用性要件 - スタンドアロンアプリの特性上、一般的な定義を採用

## 6) レビュアーチェックリスト（最小）
- [ ] フレームレンダリング目標値が実際の設計目標と一致するか確認
- [ ] 物理シミュレーションのタイムステップ設定が正しいか確認
- [ ] プラットフォーム対応状況が最新のドキュメントと一致するか確認
- [ ] セキュリティ要件がセキュリティポリシーと整合しているか確認
- [ ] サードパーティライブラリのライセンス情報が正確か確認
- [ ] C++17必須の記載がビルドドキュメントと一致するか確認
- [ ] ログローテーションのデフォルト値が運用ポリシーと適合するか確認
