# 非機能要件定義書

## 概要

本ドキュメントは、Godot Engine 4.6.0の非機能要件を定義するものです。Godot Engineはオープンソースのクロスプラットフォームゲームエンジンであり、2D/3Dゲーム開発のための統合開発環境を提供します。本書では、性能要件、可用性要件、セキュリティ要件、拡張性要件、保守性要件、および運用・監視要件について記載します。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| フレームレンダリング（60fps目標） | 16.67ms以内 | 1フレームあたりの描画処理時間 |
| フレームレンダリング（30fps目標） | 33.33ms以内 | モバイル・低スペック環境向け |
| リソースロード（非同期） | バックグラウンド実行 | WorkerThreadPoolによる並列処理 |
| スクリプト実行（GDScript） | リアルタイム処理対応 | JIT最適化なし、インタープリタ実行 |
| 物理シミュレーション | 固定タイムステップ（60Hz推奨） | 物理演算の安定性確保 |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| ワーカースレッド数 | CPU論理コア数 - 1（デフォルト） | `WorkerThreadPool.init()`で設定可能 |
| 低優先度タスク比率 | 30%（デフォルト） | `low_priority_task_ratio`パラメータ |
| タスクページサイズ | 1024タスク/ページ | `TASKS_PAGE_SIZE`定数 |
| グループページサイズ | 256グループ/ページ | `GROUPS_PAGE_SIZE`定数 |
| キャッシュラインサイズ | 128バイト | False Sharing防止用アライメント |

### メモリ管理

| 項目 | 仕様 | 備考 |
| --- | --- | --- |
| メモリアライメント | `max_align_t`または16バイト（MinGW 32bit） | `Memory::MAX_ALIGN`定数 |
| 配列アロケーション | ページドアロケータ使用 | メモリフラグメンテーション軽減 |
| リソースキャッシング | `CACHE_MODE_REUSE`デフォルト | リソースローダーのキャッシュモード |

### 最適化オプション

| 最適化レベル | フラグ | 用途 |
| --- | --- | --- |
| speed | `-O3` / `/O2` | リリース版（最高速度） |
| speed_trace | `-O2` / `/O2 /OPT:NOICF` | デバッグ可能なリリース版 |
| size | `-Os` / `/O1` | サイズ最適化 |
| size_extra | `-Os` + `SIZE_EXTRA`定義 | 最小サイズ |
| debug | `-Og` / `/Od` | デバッグ用 |
| none | `-O0` / `/Od` | 最適化なし |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 稼働率 | ローカルアプリケーションのため該当なし | スタンドアロン実行 |
| 計画停止時間 | 該当なし | ユーザー主導の停止 |
| 障害復旧時間（RTO） | 即時（再起動による復旧） | クラッシュからの復旧 |
| 目標復旧時点（RPO） | プロジェクトファイルの最終保存時点 | 自動保存機能あり |

### エラー処理

| エラー分類 | エラーコード | 説明 |
| --- | --- | --- |
| ファイルエラー | ERR_FILE_NOT_FOUND (7) | ファイルが見つからない |
| ファイルエラー | ERR_FILE_NO_PERMISSION (10) | アクセス権限なし |
| ファイルエラー | ERR_FILE_CORRUPT (16) | ファイル破損 |
| 接続エラー | ERR_TIMEOUT (24) | タイムアウト |
| 接続エラー | ERR_CANT_CONNECT (25) | 接続不可 |
| 接続エラー | ERR_CONNECTION_ERROR (27) | 接続エラー |
| リソースエラー | ERR_OUT_OF_MEMORY (6) | メモリ不足 |
| 暗号エラー | ERR_INVALID_DATA (30) | 不正なデータ |

### ログ機能

| 機能 | 説明 | ソースファイル |
| --- | --- | --- |
| 標準ロガー | stdout/stderrへの出力 | `core/io/logger.h` (StdLogger) |
| ファイルロガー | ローテーション機能付きファイル出力 | `core/io/logger.h` (RotatedFileLogger) |
| 複合ロガー | 複数ロガーの組み合わせ | `core/io/logger.h` (CompositeLogger) |
| ログバックアップ | 最大10ファイル（デフォルト） | タイムスタンプ付きバックアップ |

## セキュリティ要件

### 暗号化機能

| 機能 | アルゴリズム/プロトコル | ソースファイル |
| --- | --- | --- |
| ファイル暗号化 | AES-256 | `core/io/file_access_encrypted.h` |
| TLS/SSL通信 | mbedTLS（ビルトイン） | `modules/mbedtls/` |
| ハッシュ計算 | MD5, SHA1, SHA256 | `core/crypto/hashing_context.h` |
| HMAC認証 | 各種ハッシュアルゴリズム対応 | `core/crypto/crypto.h` (HMACContext) |
| RSA暗号化 | 署名・検証・暗号化・復号 | `core/crypto/crypto.h` |
| X.509証明書 | 証明書の読み込み・生成・検証 | `core/crypto/crypto.h` (X509Certificate) |

### TLSオプション

| モード | 説明 | セキュリティレベル |
| --- | --- | --- |
| MODE_CLIENT | 標準クライアントモード（証明書検証あり） | 高 |
| MODE_CLIENT_UNSAFE | 証明書検証なしクライアントモード | 低（開発用） |
| MODE_SERVER | サーバーモード（秘密鍵・証明書必須） | 高 |

### セキュリティ対策

| 対策 | 実装 | 備考 |
| --- | --- | --- |
| タイミング攻撃対策 | `constant_time_compare()` | 定数時間比較関数 |
| 乱数生成 | 暗号学的に安全な乱数生成 | `generate_random_bytes()` |
| システム証明書 | OSの証明書ストア利用可能 | `get_system_ca_certificates()` |
| エントロピー取得 | OS固有の安全なエントロピー源 | `OS::get_entropy()` |

## 拡張性要件

### マルチプラットフォーム対応

| プラットフォーム | サポート状況 | 検出ファイル |
| --- | --- | --- |
| Windows | サポート | `platform/windows/detect.py` |
| macOS | サポート | `platform/macos/detect.py` |
| Linux/BSD | サポート | `platform/linuxbsd/detect.py` |
| Android | サポート | `platform/android/detect.py` |
| iOS | サポート | `platform/ios/detect.py` |
| visionOS | サポート | `platform/visionos/detect.py` |
| Web (Emscripten) | サポート | `platform/web/detect.py` |

### レンダリングバックエンド

| バックエンド | 対応プラットフォーム | ビルドオプション |
| --- | --- | --- |
| Vulkan | Windows, Linux, macOS, Android | `vulkan=yes`（デフォルト） |
| OpenGL ES 3.0/GLES3 | 全プラットフォーム | `opengl3=yes`（デフォルト） |
| Direct3D 12 | Windows | `d3d12=yes` |
| Metal | macOS, iOS, visionOS (Apple arm64) | `metal=yes` |

### モジュールシステム

| 機能 | 説明 | 備考 |
| --- | --- | --- |
| ビルトインモジュール | `modules/`ディレクトリ配下 | 標準モジュール群 |
| カスタムモジュール | `custom_modules`オプション | ユーザー定義モジュール |
| モジュール有効/無効 | `module_<name>_enabled`オプション | ビルド時選択可能 |
| GDExtension | 動的ライブラリ拡張 | `core/extension/` |

### アーキテクチャサポート

| アーキテクチャ | 対応状況 |
| --- | --- |
| x86_64 | SSE 4.2最適化（Intel Nehalem以降） |
| x86_32 | SSE2最適化 |
| arm64 | ネイティブサポート |
| arm32 | レガシーサポート |

## 保守性要件

### コーディング規約

| 項目 | 要件 | 備考 |
| --- | --- | --- |
| C++バージョン | C++17 (gnu++17) | 保証されたコピー省略が必要 |
| Cバージョン | C17 (gnu17) | GCC/Clang使用時 |
| コンパイラ最小バージョン | GCC 9+, Clang 6+, Apple Clang 16+, MSVC 15.9+ | C++17フルサポート必須 |
| 例外処理 | デフォルト無効（`disable_exceptions`） | バイナリサイズ約20%削減 |

### ビルドシステム

| 項目 | 要件 | 備考 |
| --- | --- | --- |
| ビルドツール | SCons 4.0以上 | Python 3.8以上必須 |
| キャッシュ機能 | SCons cache対応 | `cache_path`オプション |
| 並列ビルド | 自動CPU検出 | `num_jobs`オプション |
| ニンジャ対応 | SCons 4.2以上で利用可能 | `ninja=yes`オプション |
| コンパイルDB | `compile_commands.json`生成 | `compiledb=yes`オプション |

### テスト機能

| 機能 | 説明 | 備考 |
| --- | --- | --- |
| ユニットテスト | `tests=yes`でビルド | doctest使用 |
| 開発モード | `dev_mode=yes` | verbose, werror, tests有効化 |
| 厳格チェック | `strict_checks=yes` | より厳密な検証 |

### デバッグサポート

| 機能 | 説明 | ソースファイル |
| --- | --- | --- |
| デバッグシンボル | DWARF-4/5形式 | `debug_symbols=yes` |
| 相対パス | デバッグシンボルの相対パス化 | `debug_paths_relative=yes` |
| 分離シンボル | シンボルを別ファイルに抽出 | `separate_debug_symbols=yes` |
| リモートデバッガ | スクリプトデバッグ対応 | `core/debugger/` |

## 運用・監視要件

### プロファイリング機能

| プロファイラ | 対応状況 | ビルドオプション |
| --- | --- | --- |
| Tracy | サポート | `profiler=tracy` |
| Perfetto | サポート | `profiler=perfetto` |
| Apple Instruments | macOS/iOS対応 | `profiler=instruments` |
| なし（デフォルト） | スタブマクロのみ | `profiler=none` |

### プロファイリング機能詳細

| 機能 | マクロ | 説明 |
| --- | --- | --- |
| フレームマーク | `GodotProfileFrameMark` | フレーム境界の記録 |
| ゾーン記録 | `GodotProfileZone(name)` | スコープ内の処理時間計測 |
| メモリ追跡 | `GodotProfileAlloc/Free` | メモリ割り当て追跡（オプション） |
| スクリプトゾーン | `GodotProfileZoneScript` | スクリプト実行の追跡 |

### 省電力モード

| 設定 | 説明 | デフォルト値 |
| --- | --- | --- |
| 低プロセッサ使用モード | CPUアイドル時のスリープ有効化 | 無効 |
| スリープ時間 | アイドル時のスリープ時間 | 10,000μs (10ms) |
| デルタスムージング | フレームレート平滑化 | 無効 |

### ベンチマーク機能

| 機能 | 説明 | 備考 |
| --- | --- | --- |
| ベンチマークモード | 処理時間の計測・記録 | `use_benchmark`フラグ |
| 出力ファイル | ベンチマーク結果のファイル出力 | `benchmark_file`設定 |
| マーク記録 | 開始・終了時刻の記録 | HashMap管理 |

## 備考

### ライセンス

Godot EngineはMITライセンスの下で公開されています。サードパーティライブラリは個別のライセンスに従います。

### サードパーティライブラリ（ビルトインオプション）

| ライブラリ | 用途 | デフォルト |
| --- | --- | --- |
| mbedTLS | TLS/暗号化 | ビルトイン |
| Vulkan (volk) | グラフィックスAPI | ビルトイン |
| FreeType | フォントレンダリング | ビルトイン |
| HarfBuzz | テキストシェーピング | ビルトイン |
| zlib/zstd | 圧縮 | ビルトイン |
| libpng/libjpeg-turbo/libwebp | 画像形式 | ビルトイン |

### 制約事項

1. **スレッドサポート**: `threads=yes`（デフォルト）でマルチスレッド有効。無効化可能だが機能制限あり
2. **浮動小数点精度**: `single`（デフォルト）または`double`を選択可能
3. **例外処理**: パフォーマンス上の理由からデフォルトで無効
4. **LTO**: プロダクションビルドで推奨（`lto=auto/thin/full`）
