---
generated_at: 2026-01-22 18:30:00
metrics:
  claims_total: 42
  claims_with_evidence: 40
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：API設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：40 / 42、根拠なし：2
- 優先レビュー（高）
  1. **最大同時接続数のデフォルト値**：コードに明示的な値なし
  2. **リッスンキューサイズのデフォルト値**：IdListenQueueDefaultを参照するが具体値不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.pas` - メインユニット、型定義とプロバイダ切り替え
- E-02: `src/Horse.Core.pas` - コアルーティング機能、HTTPメソッド登録
- E-03: `src/Horse.Core.Route.pas` - ルート定義クラス
- E-04: `src/Horse.Request.pas` - THorseRequestクラス定義
- E-05: `src/Horse.Response.pas` - THorseResponseクラス定義
- E-06: `src/Horse.Commons.pas` - 共通型定義（THTTPStatus, TMimeTypes, TMethodType）
- E-07: `src/Horse.Callback.pas` - コールバック型定義
- E-08: `src/Horse.Core.RouterTree.pas` - ルーティングツリー実装
- E-09: `src/Horse.Core.Param.pas` - パラメータ処理クラス
- E-10: `src/Horse.Exception.pas` - 例外クラス定義
- E-11: `src/Horse.Provider.Abstract.pas` - 抽象プロバイダクラス
- E-12: `src/Horse.Provider.Console.pas` - コンソールプロバイダ実装
- E-13: `src/Horse.Constants.pas` - 定数定義（デフォルトポート、ホスト、バージョン）
- E-14: `README.md` - プロジェクト概要、ミドルウェア一覧
- E-15: `samples/delphi/vcl/src/Main.Form.pas` - VCLサンプル

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HorseはExpress.jsにインスパイアされたWebフレームワーク | E-14 | ○ |
| C-02 | デフォルトホストは0.0.0.0 | E-13 | ○ |
| C-03 | デフォルトポートは9000 | E-13 | ○ |
| C-04 | フレームワークバージョンは3.1.9 | E-13 | ○ |
| C-05 | GET/POST/PUT/PATCH/DELETE/HEAD/ALLメソッドをサポート | E-02 | ○ |
| C-06 | PATCHはDelphi XE8以降/FPCでサポート | E-02 | ○ |
| C-07 | DELETEはDelphi XE8以降/FPCでサポート | E-02 | ○ |
| C-08 | THorseCallback型のシグネチャ | E-07 | ○ |
| C-09 | THorseCallbackRequestResponse型のシグネチャ | E-07 | ○ |
| C-10 | THorseCallbackRequest型のシグネチャ | E-07 | ○ |
| C-11 | THorseCallbackResponse型のシグネチャ | E-07 | ○ |
| C-12 | THorseRequest.Bodyメソッドの存在 | E-04 | ○ |
| C-13 | THorseRequest.Headersメソッドの存在 | E-04 | ○ |
| C-14 | THorseRequest.Queryメソッドの存在 | E-04 | ○ |
| C-15 | THorseRequest.Paramsメソッドの存在 | E-04 | ○ |
| C-16 | THorseRequest.Cookieメソッドの存在 | E-04 | ○ |
| C-17 | THorseRequest.ContentFieldsメソッドの存在 | E-04 | ○ |
| C-18 | THorseRequest.Sessionメソッドの存在 | E-04 | ○ |
| C-19 | THorseRequest.MethodTypeメソッドの存在 | E-04 | ○ |
| C-20 | THorseRequest.ContentTypeメソッドの存在 | E-04 | ○ |
| C-21 | THorseResponse.Sendメソッドの存在 | E-05 | ○ |
| C-22 | THorseResponse.Statusメソッドの存在 | E-05 | ○ |
| C-23 | THorseResponse.RedirectToメソッドの存在 | E-05 | ○ |
| C-24 | THorseResponse.SendFileメソッドの存在 | E-05 | ○ |
| C-25 | THorseResponse.Downloadメソッドの存在 | E-05 | ○ |
| C-26 | THorseResponse.Renderメソッドの存在 | E-05 | ○ |
| C-27 | THorseResponse.AddHeaderメソッドの存在 | E-05 | ○ |
| C-28 | THorseResponse.ContentTypeメソッドの存在 | E-05 | ○ |
| C-29 | THTTPStatus列挙型の定義 | E-06 | ○ |
| C-30 | TMimeTypes列挙型の定義 | E-06 | ○ |
| C-31 | EHorseExceptionクラスの存在 | E-10 | ○ |
| C-32 | EHorseException.Errorメソッドの存在 | E-10 | ○ |
| C-33 | EHorseException.Statusメソッドの存在 | E-10 | ○ |
| C-34 | EHorseException.ToJSONメソッドの存在 | E-10 | ○ |
| C-35 | THorse.Useメソッド（ミドルウェア登録）の存在 | E-02 | ○ |
| C-36 | THorse.Routeメソッドの存在 | E-02 | ○ |
| C-37 | THorse.Groupメソッドの存在 | E-02 | ○ |
| C-38 | Listenメソッドのオーバーロード | E-12 | ○ |
| C-39 | KeepConnectionAliveプロパティのデフォルトTrue | E-12 | ○ |
| C-40 | パスパラメータ（:param）のサポート | E-08 | ○ |
| C-41 | MaxConnectionsのデフォルト値 | **根拠なし** | △ |
| C-42 | ListenQueueのデフォルト値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **MaxConnectionsのデフォルト値**：コード上は初期値が設定されておらず、0または未設定の場合の動作が明示されていない
  - 候補：IdHTTPWebBrokerBridgeのデフォルト値を継承 / 0の場合は無制限 / 明示的設定必須
- **ListenQueueのデフォルト値**：`IdListenQueueDefault`定数を参照するが、Indy内部の値であり外部仕様として確定しない
  - 候補：Indyのデフォルト値（通常15-128程度） / 実行環境依存

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：フレームワークの基本機能（ルーティング、リクエスト/レスポンス処理）は全てソースコードで確認済み
- 0（低リスク）：HTTPステータスコード、MIMEタイプはHorse.Commons.pasで完全に定義されている
- 1（中リスク）：ミドルウェアの詳細仕様は外部リポジトリに依存するため、本設計書では概要のみ記載
- 1（中リスク）：SSL/TLS設定の詳細はIOHandleSSLインターフェースに依存し、本設計書では網羅していない

## 6) レビュアーチェックリスト（最小）
- [ ] HTTPメソッド（GET/POST/PUT/PATCH/DELETE/HEAD）の実装がコードと一致することを確認
- [ ] THorseRequest/THorseResponseのメソッド一覧がコードと一致することを確認
- [ ] デフォルトポート（9000）、デフォルトホスト（0.0.0.0）がHorse.Constants.pasと一致することを確認
- [ ] THTTPStatus列挙型の値がHorse.Commons.pasと一致することを確認
- [ ] TMimeTypes列挙型の値がHorse.Commons.pasと一致することを確認
- [ ] EHorseExceptionのJSON出力形式がHorse.Exception.pasのToJSONObject実装と一致することを確認
- [ ] 対応Delphiバージョン一覧がREADME.mdと一致することを確認
- [ ] 公式ミドルウェア一覧がREADME.mdと一致することを確認
