# Horse

## 概要

HorseはNode.jsのExpressにインスパイアされた、Delphi/Lazarus向けの軽量かつ高性能なWebフレームワークです。ミニマリストな設計思想に基づき、シンプルなAPIで迅速なWeb開発を実現します。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| HTTPルーティング | GET/POST/PUT/DELETE/PATCH/HEAD等のHTTPメソッドに対応したルーティング |
| ミドルウェア | Use()メソッドによるミドルウェアチェーンの構築 |
| リクエスト処理 | ヘッダー、クエリパラメータ、パスパラメータ、Cookie、フォームデータの取得 |
| レスポンス生成 | テキスト送信、ファイル送信、ダウンロード、リダイレクト対応 |
| SSL/TLS対応 | OpenSSLを使用したHTTPS通信のサポート |
| マルチプロバイダー | Console、VCL、CGI、FastCGI、ISAPI、Apache、Daemon等の多様な実行環境 |
| ルートグループ | Route()とGroup()によるルートの構造化 |
| HTTPステータス | 全HTTPステータスコードの列挙型サポート |
| MIMEタイプ | 主要なMIMEタイプの自動判定と設定 |
| セッション管理 | リクエストごとのセッションオブジェクト管理 |

## 技術スタック

### コア

- フレームワーク: Horse（自己完結型Webフレームワーク）
- 言語: Object Pascal（Delphi/Free Pascal）
- ランタイム: Indy（TIdHTTPWebBrokerBridge）
- パッケージマネージャー: Boss

### 主要ライブラリ

- Web.HTTPApp（Delphi標準Webアプリケーションモジュール）
- IdHTTPWebBrokerBridge（Indy HTTPブリッジ）
- IdSSLOpenSSL（SSL/TLSサポート）
- fpHTTP/HTTPDefs（Free Pascal用HTTPモジュール）

## ディレクトリ構成

```
horse-master/
├── src/                          # メインソースコード
│   ├── Horse.pas                 # メインエントリーポイント
│   ├── Horse.Core.pas            # コアルーティング機能
│   ├── Horse.Request.pas         # リクエスト処理クラス
│   ├── Horse.Response.pas        # レスポンス生成クラス
│   ├── Horse.Commons.pas         # 共通型定義（HTTPステータス、MIMEタイプ等）
│   ├── Horse.Callback.pas        # コールバック型定義
│   ├── Horse.Core.RouterTree.pas # ルーティングツリー実装
│   ├── Horse.Core.Param.pas      # パラメータ処理
│   ├── Horse.Core.Group.pas      # ルートグループ機能
│   ├── Horse.Core.Route.pas      # ルート定義機能
│   ├── Horse.Provider.*.pas      # 各種プロバイダー実装
│   │   ├── Horse.Provider.Console.pas   # コンソールアプリ用
│   │   ├── Horse.Provider.VCL.pas       # VCLアプリ用
│   │   ├── Horse.Provider.CGI.pas       # CGI用
│   │   ├── Horse.Provider.ISAPI.pas     # ISAPI用
│   │   ├── Horse.Provider.Apache.pas    # Apacheモジュール用
│   │   └── Horse.Provider.Daemon.pas    # デーモン/サービス用
│   ├── Horse.Mime.pas            # MIMEタイプ判定
│   ├── Horse.Session.pas         # セッション管理
│   └── Horse.Exception.pas       # 例外クラス
├── samples/                      # サンプルプロジェクト
│   ├── delphi/                   # Delphi用サンプル
│   │   ├── console/              # コンソールアプリサンプル
│   │   ├── vcl/                  # VCLアプリサンプル
│   │   ├── vcl-ssl/              # SSL対応VCLサンプル
│   │   ├── cgi/                  # CGIサンプル
│   │   ├── isapi/                # ISAPIサンプル
│   │   ├── apache/               # Apacheモジュールサンプル
│   │   ├── daemon/               # デーモンサンプル
│   │   └── winsvc/               # Windowsサービスサンプル
│   └── lazarus/                  # Lazarus用サンプル
│       ├── console/              # コンソールアプリサンプル
│       ├── lcl/                  # LCLアプリサンプル
│       ├── cgi/                  # CGIサンプル
│       ├── fastcgi/              # FastCGIサンプル
│       ├── apache/               # Apacheモジュールサンプル
│       ├── daemon/               # デーモンサンプル
│       └── winsvc/               # Windowsサービスサンプル
├── tests/                        # テストコード
│   ├── src/                      # テストソース
│   │   ├── tests/                # テストケース
│   │   └── controllers/          # テスト用コントローラー
│   └── code-coverage/            # コードカバレッジ設定
├── img/                          # 画像リソース
├── .github/                      # GitHub設定
│   └── workflows/                # GitHub Actions
├── boss.json                     # Bossパッケージ設定
└── LICENSE                       # MITライセンス
```

## セットアップ

### 必要条件

- Delphi XE7以降（Delphi 13 Florence、12 Athens、11 Alexandria、10.4 Sydney、10.3 Rio、10.2 Tokyo、10.1 Berlin、10 Seattle、XE8対応）
- または Lazarus/Free Pascal

### インストール

Bossパッケージマネージャーを使用してインストールします：

```sh
boss install horse
```

または、手動でソースを取得する場合：

1. このリポジトリをクローンまたはダウンロード
2. `src/` フォルダをプロジェクトのライブラリパスに追加

### クイックスタート（Delphi）

```delphi
uses Horse;

begin
  THorse.Get('/ping',
    procedure(Req: THorseRequest; Res: THorseResponse)
    begin
      Res.Send('pong');
    end);

  THorse.Listen(9000);
end.
```

### クイックスタート（Lazarus）

```delphi
{$MODE DELPHI}{$H+}

uses Horse;

procedure GetPing(Req: THorseRequest; Res: THorseResponse);
begin
  Res.Send('Pong');
end;

begin
  THorse.Get('/ping', GetPing);
  THorse.Listen(9000);
end.
```

## 開発

### ビルド

DelphiまたはLazarus IDEでプロジェクトを開き、ビルドを実行します。

### コンパイルディレクティブ

プロバイダーを切り替えるには、以下のコンパイルディレクティブを使用：

- `HORSE_VCL` - VCLアプリケーション用
- `HORSE_CGI` - CGIアプリケーション用
- `HORSE_ISAPI` - ISAPIモジュール用
- `HORSE_APACHE` - Apacheモジュール用
- `HORSE_DAEMON` - デーモン/サービス用
- `HORSE_LCL` - LCL（Lazarus）アプリケーション用
- `HORSE_FCGI` - FastCGI用（Lazarusのみ）

### テスト

テストはDUnitXフレームワークを使用しています。

```sh
# コンソールテストの実行
./tests/Console.exe

# VCLテストの実行
./tests/VCL.exe
```

GitHub Actionsにより、master/mainブランチへのpush/pull request時に自動テストが実行されます。

### コードカバレッジ

- コンソールカバレッジ: 約45%
- VCLカバレッジ: 約43%

### ライセンス

MIT License - 詳細は[LICENSE](../../LICENSE)ファイルを参照してください。
