---
generated_at: 2026-01-22 17:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：README.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **コードカバレッジの数値**：根拠が既存READMEのみで、実測値との差異の可能性あり
  2. **パフォーマンス特性**：「高性能」という表現の客観的根拠が不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md`（プロジェクトルートの既存README）
- E-02: `boss.json`（パッケージ設定ファイル）
- E-03: `LICENSE`（ライセンスファイル）
- E-04: `src/Horse.pas`（メインユニット）
- E-05: `src/Horse.Core.pas`（コアルーティング実装）
- E-06: `src/Horse.Request.pas`（リクエスト処理クラス）
- E-07: `src/Horse.Response.pas`（レスポンス生成クラス）
- E-08: `src/Horse.Commons.pas`（共通型定義）
- E-09: `src/Horse.Provider.Console.pas`（コンソールプロバイダー）
- E-10: `samples/delphi/console/Console.dpr`（コンソールサンプル）
- E-11: `.github/workflows/tests.yml`（GitHub Actions設定）
- E-12: ディレクトリ構造（Glob結果）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HorseはExpressインスパイアのWebフレームワーク | E-01 | ○ |
| C-02 | Delphi/Lazarus向けの軽量フレームワーク | E-01, E-04 | ○ |
| C-03 | GET/POST/PUT/DELETE/PATCH/HEADメソッド対応 | E-05 | ○ |
| C-04 | ミドルウェアチェーンの構築（Use）機能 | E-05 | ○ |
| C-05 | ヘッダー、クエリ、パスパラメータ、Cookie取得 | E-06 | ○ |
| C-06 | フォームデータ（multipart/urlencoded）取得 | E-06 | ○ |
| C-07 | テキスト送信、ファイル送信、ダウンロード機能 | E-07 | ○ |
| C-08 | リダイレクト機能 | E-07 | ○ |
| C-09 | SSL/TLS対応（OpenSSL） | E-09 | ○ |
| C-10 | マルチプロバイダー対応（Console/VCL/CGI等） | E-04, E-12 | ○ |
| C-11 | Route()とGroup()によるルート構造化 | E-05 | ○ |
| C-12 | HTTPステータス列挙型サポート | E-08 | ○ |
| C-13 | MIMEタイプ自動判定 | E-08 | ○ |
| C-14 | セッション管理機能 | E-06 | ○ |
| C-15 | Indyランタイム使用 | E-09 | ○ |
| C-16 | Bossパッケージマネージャー対応 | E-01, E-02 | ○ |
| C-17 | Delphi XE7以降対応 | E-01 | ○ |
| C-18 | Lazarus/Free Pascal対応 | E-01, E-04 | ○ |
| C-19 | boss installコマンドでのインストール | E-01 | ○ |
| C-20 | クイックスタートコード（Delphi） | E-01, E-10 | ○ |
| C-21 | クイックスタートコード（Lazarus） | E-01 | ○ |
| C-22 | コンパイルディレクティブによるプロバイダー切替 | E-04 | ○ |
| C-23 | DUnitXテストフレームワーク使用 | E-11 | ○ |
| C-24 | GitHub Actionsによる自動テスト | E-11 | ○ |
| C-25 | MITライセンス | E-01, E-03 | ○ |
| C-26 | ディレクトリ構成 | E-12 | ○ |
| C-27 | コンソールカバレッジ約45%、VCLカバレッジ約43% | E-01 | △ |
| C-28 | 高性能なWebフレームワーク | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-27（コードカバレッジ数値）**：既存READMEに記載のバッジから取得したが、実際の測定日時・条件が不明。最新の実測値と異なる可能性がある。
  - 候補：tests/code-coverage/ 内の設定ファイル / CI/CDの実行結果 / カバレッジレポート
- **C-28（高性能の主張）**：既存READMEに「high performance」との記載があるが、ベンチマーク結果や比較データがない。
  - 候補：ベンチマーク結果 / 性能テストレポート / 他フレームワークとの比較データ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張はソースコードで直接検証可能
- 1: 中リスク - コードカバレッジ数値は更新が必要な可能性
- 0: 低リスク - ライセンス情報はLICENSEファイルで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] クイックスタートコードが実際に動作することを確認
- [ ] 記載されたDelphiバージョンでのコンパイル確認
- [ ] コードカバレッジ数値が最新であることを確認
- [ ] 「高性能」の表現を残すか、より客観的な表現に変更するか検討
- [ ] ディレクトリ構成が現在のリポジトリ構造と一致しているか確認
