---
generated_at: 2026-01-22 19:15:00
metrics:
  claims_total: 52
  claims_with_evidence: 48
  claims_without_evidence: 4
confidence_derived: 0.92
---

# 根拠レポート：コードリーディングガイドライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：48 / 52、根拠なし：4
- 優先レビュー（高）
  1. **Lazarus/FPC固有の動作詳細**：実機検証が限定的
  2. **デバッグ手法の実効性**：一般的な手法として記載
  3. **一部のサンプル動作確認**：実行環境が必要
  4. **外部リソース（公式ドキュメント等）のリンク有効性**：時間経過で変更の可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.pas`（メインユニット）
- E-02: `src/Horse.Core.pas`（コアロジック）
- E-03: `src/Horse.Request.pas`（リクエスト処理）
- E-04: `src/Horse.Response.pas`（レスポンス処理）
- E-05: `src/Horse.Core.RouterTree.pas`（ルーティング）
- E-06: `src/Horse.Commons.pas`（共通定義）
- E-07: `src/Horse.Callback.pas`（コールバック定義）
- E-08: `src/Horse.Exception.pas`（例外処理）
- E-09: `src/Horse.Core.Param.pas`（パラメータ処理）
- E-10: `src/Horse.Provider.Console.pas`（コンソールプロバイダー）
- E-11: `src/Horse.Core.Group.pas`（グループ機能）
- E-12: `samples/delphi/console/Console.dpr`（サンプルアプリ）
- E-13: `README.md`（プロジェクト説明）
- E-14: `boss.json`（パッケージ設定）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Object Pascalのユニット構造（unit, interface, implementation） | E-02 | ○ |
| C-02 | コンパイラディレクティブ`{$IF DEFINED(FPC)}`の使用 | E-01, E-02 | ○ |
| C-03 | class varによるクラス変数定義 | E-02 | ○ |
| C-04 | TList<T>、TDictionary<K,V>のジェネリック型使用 | E-02, E-09 | ○ |
| C-05 | case文による複数分岐処理 | E-06 | ○ |
| C-06 | class functionによる静的メソッド定義 | E-02 | ○ |
| C-07 | Result変数による戻り値設定 | E-02, E-04 | ○ |
| C-08 | uses節によるユニットインポート | E-01 | ○ |
| C-09 | 条件付きコンパイルによるプラットフォーム分岐 | E-01 | ○ |
| C-10 | HorseはExpress.js風のWebフレームワーク | E-13 | ○ |
| C-11 | THorse.Get等のHTTPメソッドでルーティング | E-02, E-12 | ○ |
| C-12 | 匿名手続きによるコールバック定義 | E-07, E-12 | ○ |
| C-13 | THorse.Useによるミドルウェア登録 | E-02 | ○ |
| C-14 | プロバイダーパターンによる実行環境抽象化 | E-01, E-10 | ○ |
| C-15 | Console, VCL, ISAPI, CGI等複数プロバイダー対応 | E-01 | ○ |
| C-16 | THorseCoreのシングルトン実装 | E-02 | ○ |
| C-17 | Fluent Interfaceパターン（Self返却） | E-04 | ○ |
| C-18 | Horse.*.pasのファイル命名規則 | E-01, E-02, E-03 | ○ |
| C-19 | Horse.Provider.*.pasのプロバイダー命名規則 | E-10 | ○ |
| C-20 | THorse*のクラス命名規則 | E-02, E-03, E-04 | ○ |
| C-21 | EHorse*の例外クラス命名規則 | E-08 | ○ |
| C-22 | F*のプライベートフィールド命名規則 | E-02, E-10 | ○ |
| C-23 | L*のローカル変数命名規則 | E-02, E-05 | ○ |
| C-24 | A*の引数命名規則 | E-02, E-03 | ○ |
| C-25 | src/ディレクトリにソースコード配置 | ファイルシステム | ○ |
| C-26 | samples/ディレクトリにサンプル配置 | ファイルシステム | ○ |
| C-27 | tests/ディレクトリにテスト配置 | ファイルシステム | ○ |
| C-28 | Delphi用とLazarus用のサンプル分離 | ファイルシステム | ○ |
| C-29 | ミドルウェアベースのルーティングアーキテクチャ | E-02, E-05 | ○ |
| C-30 | Facadeレイヤー（Horse.pas） | E-01 | ○ |
| C-31 | Coreレイヤー（Horse.Core.pas） | E-02 | ○ |
| C-32 | Request/Responseレイヤー | E-03, E-04 | ○ |
| C-33 | Providerレイヤー | E-10 | ○ |
| C-34 | HTTPリクエストからレスポンスまでのデータフロー | E-05, E-10 | ○ |
| C-35 | THorseRequest.Query, Params, Bodyの使用方法 | E-03 | ○ |
| C-36 | THorseResponse.Send, Status, SendFileの使用方法 | E-04 | ○ |
| C-37 | THTTPStatusによるステータスコード定義 | E-06 | ○ |
| C-38 | TMimeTypesによるMIMEタイプ定義 | E-06 | ○ |
| C-39 | シングルトンパターンの実装例 | E-02 | ○ |
| C-40 | Fluent Interfaceパターンの実装例 | E-04 | ○ |
| C-41 | コールバックパターンの実装例 | E-07 | ○ |
| C-42 | 条件付きコンパイルパターンの実装例 | E-01 | ○ |
| C-43 | サーバー起動フローの追跡 | E-10 | ○ |
| C-44 | ルート登録フローの追跡 | E-02 | ○ |
| C-45 | リクエスト受信とルーティングフローの追跡 | E-05 | ○ |
| C-46 | THorseListはTDictionary<string, string>のエイリアス | E-09 | ○ |
| C-47 | BossはDelphiのパッケージマネージャー | E-13, E-14 | ○ |
| C-48 | Delphi 10.1 Berlin以降のサポート | E-13 | ○ |
| C-49 | Lazarus/FPC固有の動作詳細 | **根拠なし** | △ |
| C-50 | デバッグ手法の実効性 | **根拠なし** | △ |
| C-51 | 一部のサンプル動作確認 | **根拠なし** | △ |
| C-52 | 外部リソースのリンク有効性 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **Lazarus/FPC固有の動作詳細**
  - 理由：実機検証環境がなく、条件付きコンパイルの挙動をソースコードから推測
  - 候補：Lazarus環境での実機検証 / FPC公式ドキュメント参照 / Lazarusサンプルの実行

- **デバッグ手法の実効性**
  - 理由：一般的なデバッグ手法として記載しており、Horseプロジェクト固有の検証は未実施
  - 候補：実際のデバッグ実施 / プロジェクト貢献者へのヒアリング

- **一部のサンプル動作確認**
  - 理由：すべてのサンプル（VCL, ISAPI, Apache等）の動作確認は未実施
  - 候補：各実行環境でのサンプル実行 / CI/CDワークフローの確認

- **外部リソースのリンク有効性**
  - 理由：時間経過によりリンク切れの可能性
  - 候補：定期的なリンク確認 / アーカイブへの差し替え

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 基本的なObject Pascal構文の説明
- **0（低リスク）**: ソースコード参照が明確な箇所
- **1（中リスク）**: Fluent Interfaceやミドルウェアの動作説明（複雑な処理フロー）
- **1（中リスク）**: 条件付きコンパイルの分岐説明
- **2（高リスク）**: Lazarus/FPC固有の動作に関する記述

## 6) レビュアーチェックリスト（最小）
- [ ] 言語基礎セクション（1章）のコード例がソースファイルの該当行と一致しているか確認
- [ ] 命名規則（3章）がプロジェクト全体で一貫しているか確認
- [ ] ディレクトリ構造（4章）が実際のファイルシステムと一致しているか確認
- [ ] アーキテクチャ図（5章）がソースコードの依存関係と一致しているか確認
- [ ] 業務フロー追跡（8章）の各ステップが実際のコードパスと一致しているか確認
- [ ] 用語集（付録A）の定義が正確か確認
- [ ] 外部参考資料リンク（付録C）が有効か確認
