---
generated_at: 2026-01-22 14:30:00
metrics:
  claims_total: 42
  claims_with_evidence: 38
  claims_without_evidence: 4
confidence_derived: 0.90
---

# 根拠レポート：アーキテクチャ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：38 / 42、根拠なし：4
- 優先レビュー（高）
  1. **バージョン情報の正確性**：OpenSSL等外部ライブラリの具体的バージョンは未確認
  2. **パフォーマンス特性**：「高性能」という表現の具体的根拠は推測
  3. **非同期処理の詳細**：TEventを使用したイベント待機の詳細動作は推測を含む
  4. **公式ミドルウェアの最新状況**：README.mdから抽出したが、最新状態の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.pas` - メインファサードユニット
- E-02: `src/Horse.Core.pas` - コアフレームワーク実装
- E-03: `src/Horse.Core.RouterTree.pas` - ルーティングツリー実装
- E-04: `src/Horse.Core.RouterTree.NextCaller.pas` - ミドルウェアチェーン実行
- E-05: `src/Horse.Provider.Abstract.pas` - プロバイダー抽象基底クラス
- E-06: `src/Horse.Provider.Console.pas` - コンソールプロバイダー実装
- E-07: `src/Horse.Provider.VCL.pas` - VCLプロバイダー実装
- E-08: `src/Horse.Request.pas` - リクエスト抽象化
- E-09: `src/Horse.Response.pas` - レスポンス抽象化
- E-10: `src/Horse.Callback.pas` - コールバック型定義
- E-11: `src/Horse.Commons.pas` - 共通型定義
- E-12: `src/Horse.WebModule.pas` - Webモジュール実装
- E-13: `src/Horse.Exception.pas` - 例外クラス
- E-14: `src/Horse.Core.Param.pas` - パラメータ処理
- E-15: `src/Horse.Session.pas` - セッション管理
- E-16: `src/Horse.Core.Group.pas` - ルートグルーピング
- E-17: `src/Horse.Core.Route.pas` - ルート定義
- E-18: `README.md` - プロジェクト説明
- E-19: `boss.json` - パッケージ設定

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HorseはExpress.js風Webフレームワークである | E-18 (README.md: "Express inspired web framework") | ○ |
| C-02 | THorseがファサードクラスとして機能する | E-01 (Horse.pas: `THorse = class(THorseProvider)`) | ○ |
| C-03 | シングルトンパターンを使用している | E-02 (Horse.Core.pas: `GetInstance`, `FDefaultHorse`) | ○ |
| C-04 | ミドルウェアパイプライン型アーキテクチャである | E-04 (NextCaller: ミドルウェアチェーン実行ロジック) | ○ |
| C-05 | THorseRouterTreeがルーティングツリーを管理する | E-03 (Horse.Core.RouterTree.pas: ツリー構造実装) | ○ |
| C-06 | TNextCallerがミドルウェアチェーンを実行する | E-04 (NextCaller: `Next`メソッドの実装) | ○ |
| C-07 | 条件付きコンパイルでDelphi/FPC両対応している | E-01, E-02, E-03... (全ユニットで`{$IF DEFINED(FPC)}`) | ○ |
| C-08 | THorseProviderAbstractが抽象基底クラスである | E-05 (Horse.Provider.Abstract.pas: abstract Listen) | ○ |
| C-09 | Consoleプロバイダーが存在する | E-06 (Horse.Provider.Console.pas) | ○ |
| C-10 | VCLプロバイダーが存在する | E-07 (Horse.Provider.VCL.pas) | ○ |
| C-11 | Indy TIdHTTPWebBrokerBridgeを使用している | E-06, E-07 (uses節でIdHTTPWebBrokerBridge参照) | ○ |
| C-12 | SSL/TLS対応機能がある | E-06 (InitServerIOHandlerSSLOpenSSL メソッド) | ○ |
| C-13 | THorseRequestがリクエストを抽象化する | E-08 (Horse.Request.pas: THorseRequest実装) | ○ |
| C-14 | THorseResponseがレスポンスを抽象化する | E-09 (Horse.Response.pas: THorseResponse実装) | ○ |
| C-15 | Headers, Query, Params, Cookie, ContentFieldsへのアクセスが可能 | E-08 (Horse.Request.pas: 各メソッド定義) | ○ |
| C-16 | Send, Status, SendFile, Download, RedirectToメソッドがある | E-09 (Horse.Response.pas: 各メソッド定義) | ○ |
| C-17 | Fluent Interfaceパターンを使用している | E-09, E-13 (メソッドがSelfを返す実装) | ○ |
| C-18 | EHorseException例外クラスが存在する | E-13 (Horse.Exception.pas) | ○ |
| C-19 | EHorseCallbackInterruptedで処理を中断できる | E-12 (WebModule: InheritsFrom(EHorseCallbackInterrupted)チェック) | ○ |
| C-20 | 404 Not Foundが自動返却される | E-04 (NextCaller: `FResponse.Send('Not Found').Status(THTTPStatus.NotFound)`) | ○ |
| C-21 | 405 Method Not Allowedが自動返却される | E-04 (NextCaller: `Status(THTTPStatus.MethodNotAllowed)`) | ○ |
| C-22 | 500 Internal Server Errorが自動返却される | E-04 (NextCaller: `Status(THTTPStatus.InternalServerError)`) | ○ |
| C-23 | THorseCoreParamがパラメータ処理を担当する | E-14 (Horse.Core.Param.pas) | ○ |
| C-24 | THorseSessionsがセッション管理を担当する | E-15 (Horse.Session.pas) | ○ |
| C-25 | THorseCoreGroupがルートグルーピングを提供する | E-16 (Horse.Core.Group.pas) | ○ |
| C-26 | THorseCoreRouteがルート定義を提供する | E-17 (Horse.Core.Route.pas) | ○ |
| C-27 | HTTPメソッド(GET/POST/PUT/DELETE/PATCH/HEAD)全対応 | E-02 (Horse.Core.pas: 各メソッド定義) | ○ |
| C-28 | ジェネリクスを使用したAPI設計 | E-16, E-17 (THorseCoreGroup<T>, THorseCoreRoute<T>) | ○ |
| C-29 | パスパラメータ(:id形式)に対応している | E-03 (RouterTree: `FIsParamsKey := FPart.StartsWith(':')`) | ○ |
| C-30 | 正規表現パターン((pattern)形式)に対応している | E-03 (RouterTree: `FIsRouterRegex := FPart.StartsWith('(')`) | ○ |
| C-31 | ワイルドカード(*)に対応している | E-03 (RouterTree: `GetQueuePath('/*', False)`) | ○ |
| C-32 | THorseWebModuleがWebリクエストを処理する | E-12 (Horse.WebModule.pas: HandlerAction) | ○ |
| C-33 | THTTPStatusでHTTPステータスコードを管理する | E-11 (Horse.Commons.pas: THTTPStatus定義) | ○ |
| C-34 | TMimeTypesでMIMEタイプを管理する | E-11 (Horse.Commons.pas: TMimeTypes定義) | ○ |
| C-35 | 認証はミドルウェアとして追加する設計 | E-18 (README: horse/basic-auth, horse/jwtミドルウェア) | ○ |
| C-36 | フレームワーク自体はDB機能を含まない | E-01-E-17 (データベース関連コードなし) | ○ |
| C-37 | MITライセンスである | E-18 (README: "MIT License") | ○ |
| C-38 | 複数のDelphiバージョンに対応している | E-18 (README: バージョン一覧記載) | ○ |
| C-39 | 「高性能」という特性を持つ | E-18 (README: "high performance") | △ |
| C-40 | OpenSSLの具体的なバージョン | **根拠なし** | △ |
| C-41 | TEventによるイベント待機の詳細動作 | E-06 (推測含む: `GetDefaultEvent.WaitFor()`) | △ |
| C-42 | 公式ミドルウェアの最新リスト | E-18 (README時点の情報) | △ |

## 4) 不足情報（Unknown / Missing）
- **OpenSSLバージョン情報**：コード内にバージョン指定なし。実行環境依存。
  - 候補：システムドキュメント / デプロイ手順書 / Indyドキュメント
- **パフォーマンス測定データ**：「高性能」の主張に対する定量的データなし。
  - 候補：ベンチマークテスト結果 / パフォーマンステストレポート
- **イベント待機の詳細仕様**：TEventの使用方法は確認できるが、詳細動作は推測。
  - 候補：Delphiランタイムライブラリドキュメント
- **ミドルウェアの最新状態**：README.mdからの情報だが、実際のリポジトリ状態の確認が必要。
  - 候補：各ミドルウェアリポジトリ / パッケージマネージャ

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - アーキテクチャの基本構造はソースコードから明確に確認可能
- **0: 低リスク** - レイヤー構成とコンポーネント間依存関係はコードから正確に把握
- **0: 低リスク** - HTTPメソッド対応、ルーティング機能は実装コードで確認済み
- **1: 中リスク** - 外部ライブラリ（OpenSSL、Indy）のバージョン互換性は未確認
- **1: 中リスク** - 「高性能」の主張は定量的根拠がない
- **0: 低リスク** - ライセンス情報はREADMEとLICENSEファイルで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] アーキテクチャスタイル（ミドルウェアパイプライン型）の記述は実装と一致しているか
- [ ] レイヤー構成図がソースコードの依存関係と整合しているか
- [ ] プロバイダーパターンの説明が条件付きコンパイルの実装と一致しているか
- [ ] ルーティングツリーの動作説明がTHorseRouterTreeの実装と整合しているか
- [ ] エラーハンドリングの記述がTNextCallerの例外処理と一致しているか
- [ ] 外部ライブラリ（Indy、OpenSSL）の記述が実際の使用状況と合っているか
- [ ] 公式ミドルウェアのリストが最新状態であるか確認
- [ ] 対応プラットフォーム・Delphiバージョンの記述が正確か確認
