# アーキテクチャ構成図

## システム全体構成図

```mermaid
graph TB
    subgraph "External"
        CLIENT[HTTP Client]
        SSL[OpenSSL Library]
    end

    subgraph "Horse Framework"
        subgraph "Facade Layer"
            HORSE[THorse<br/>Horse.pas]
        end

        subgraph "Core Layer"
            CORE[THorseCore<br/>Horse.Core.pas]
            ROUTER[THorseRouterTree<br/>Horse.Core.RouterTree.pas]
            NEXTCALLER[TNextCaller<br/>Horse.Core.RouterTree.NextCaller.pas]
            ROUTE[THorseCoreRoute<br/>Horse.Core.Route.pas]
            GROUP[THorseCoreGroup<br/>Horse.Core.Group.pas]
        end

        subgraph "Provider Layer"
            ABSTRACT[THorseProviderAbstract<br/>Horse.Provider.Abstract.pas]
            CONSOLE[THorseProvider<br/>Console]
            VCL[THorseProvider<br/>VCL]
            CGI[THorseProvider<br/>CGI]
            APACHE[THorseProvider<br/>Apache]
            ISAPI[THorseProvider<br/>ISAPI]
            DAEMON[THorseProvider<br/>Daemon]
        end

        subgraph "Web Module Layer"
            WEBMODULE[THorseWebModule<br/>Horse.WebModule.pas]
        end

        subgraph "Request/Response Layer"
            REQUEST[THorseRequest<br/>Horse.Request.pas]
            RESPONSE[THorseResponse<br/>Horse.Response.pas]
            PARAM[THorseCoreParam<br/>Horse.Core.Param.pas]
            SESSION[THorseSessions<br/>Horse.Session.pas]
            FILES[THorseCoreFile<br/>Horse.Core.Files.pas]
        end

        subgraph "Commons Layer"
            COMMONS[Horse.Commons.pas]
            MIME[Horse.Mime.pas]
            CALLBACK[Horse.Callback.pas]
            EXCEPTION[Horse.Exception.pas]
        end
    end

    subgraph "Platform Libraries"
        INDY[Indy<br/>TIdHTTPWebBrokerBridge]
        FPWEB[fpWeb/fpHTTP<br/>Lazarus]
    end

    CLIENT -->|HTTP/HTTPS| HORSE
    HORSE --> CONSOLE
    HORSE --> VCL
    HORSE --> CGI
    HORSE --> APACHE
    HORSE --> ISAPI
    HORSE --> DAEMON

    CONSOLE --> ABSTRACT
    VCL --> ABSTRACT
    CGI --> ABSTRACT
    APACHE --> ABSTRACT
    ISAPI --> ABSTRACT
    DAEMON --> ABSTRACT

    ABSTRACT --> CORE
    CORE --> ROUTER
    ROUTER --> NEXTCALLER
    CORE --> ROUTE
    CORE --> GROUP

    WEBMODULE --> CORE
    WEBMODULE --> REQUEST
    WEBMODULE --> RESPONSE

    REQUEST --> PARAM
    REQUEST --> SESSION
    RESPONSE --> FILES
    RESPONSE --> MIME

    NEXTCALLER --> CALLBACK
    NEXTCALLER --> EXCEPTION

    CONSOLE --> INDY
    VCL --> INDY
    CGI --> FPWEB
    APACHE --> FPWEB

    INDY --> SSL
```

## リクエスト処理フロー図

```mermaid
sequenceDiagram
    participant C as HTTP Client
    participant P as THorseProvider
    participant WM as THorseWebModule
    participant RT as THorseRouterTree
    participant NC as TNextCaller
    participant MW as Middleware
    participant CB as Callback Handler
    participant RQ as THorseRequest
    participant RS as THorseResponse

    C->>P: HTTP Request
    P->>WM: HandlerAction()
    WM->>RQ: Create(WebRequest)
    WM->>RS: Create(WebResponse)
    WM->>RT: Execute(Request, Response)
    RT->>RT: GetQueuePath(PathInfo)
    RT->>NC: ExecuteInternal()
    NC->>NC: Init()

    loop Middleware Chain
        NC->>MW: Execute(Req, Res, Next)
        MW->>NC: Next()
    end

    NC->>CB: Execute(Req, Res, Next)
    CB->>RS: Send(Content)
    RS-->>WM: Response Ready
    WM->>RQ: Free()
    WM->>RS: Free()
    WM-->>P: Handled = True
    P-->>C: HTTP Response
```

## レイヤー構成図

```mermaid
graph TB
    subgraph "Application"
        APP[User Application]
    end

    subgraph "Facade"
        direction LR
        FACADE[THorse]
    end

    subgraph "Core"
        direction LR
        CORE_MAIN[THorseCore]
        CORE_ROUTER[THorseRouterTree]
        CORE_ROUTE[THorseCoreRoute]
        CORE_GROUP[THorseCoreGroup]
    end

    subgraph "Provider"
        direction LR
        PROV_ABSTRACT[THorseProviderAbstract]
        PROV_CONSOLE[Console Provider]
        PROV_VCL[VCL Provider]
        PROV_CGI[CGI Provider]
        PROV_APACHE[Apache Provider]
    end

    subgraph "Request/Response"
        direction LR
        REQ[THorseRequest]
        RES[THorseResponse]
        PARAM[THorseCoreParam]
    end

    subgraph "Commons"
        direction LR
        COMMONS_TYPE[Types & Helpers]
        COMMONS_EX[Exceptions]
        COMMONS_CB[Callbacks]
    end

    APP --> FACADE
    FACADE --> PROV_CONSOLE
    FACADE --> PROV_VCL
    FACADE --> PROV_CGI
    FACADE --> PROV_APACHE

    PROV_CONSOLE --> PROV_ABSTRACT
    PROV_VCL --> PROV_ABSTRACT
    PROV_CGI --> PROV_ABSTRACT
    PROV_APACHE --> PROV_ABSTRACT

    PROV_ABSTRACT --> CORE_MAIN
    CORE_MAIN --> CORE_ROUTER
    CORE_MAIN --> CORE_ROUTE
    CORE_MAIN --> CORE_GROUP

    CORE_ROUTER --> REQ
    CORE_ROUTER --> RES
    REQ --> PARAM

    REQ --> COMMONS_TYPE
    RES --> COMMONS_TYPE
    CORE_ROUTER --> COMMONS_CB
    CORE_ROUTER --> COMMONS_EX
```

## ミドルウェアパイプライン図

```mermaid
graph LR
    subgraph "Request Pipeline"
        direction LR
        REQ[Request] --> MW1[Middleware 1]
        MW1 --> MW2[Middleware 2]
        MW2 --> MW3[Middleware N]
        MW3 --> HANDLER[Route Handler]
    end

    subgraph "Response Pipeline"
        direction RL
        HANDLER --> RES[Response]
    end

    subgraph "Next Chain"
        direction TB
        NC[TNextCaller]
        NC -->|"FIndex < FMiddleware.Count"| EXEC_MW[Execute Middleware]
        EXEC_MW -->|"Next()"| NC
        NC -->|"FPath.Count = 0"| EXEC_CB[Execute Callback]
        NC -->|"FPath.Count > 0"| CALL_NEXT[CallNextPath]
    end
```

## ルーティングツリー構造図

```mermaid
graph TB
    subgraph "Router Tree Structure"
        ROOT[Root<br/>"/"]

        ROOT --> API[api]
        ROOT --> STATIC[static]

        API --> USERS[users]
        API --> PRODUCTS[products]

        USERS --> USER_ID[":id"<br/>Dynamic Param]
        USERS --> USER_ALL["*"<br/>Wildcard]

        PRODUCTS --> PROD_ID[":id"<br/>Dynamic Param]
        PRODUCTS --> PROD_REGEX["(regex)"<br/>Regex Pattern]

        subgraph "Node Properties"
            NODE[THorseRouterTree]
            NODE --> |FPart| PART[Path Segment]
            NODE --> |FIsParamsKey| PARAMS[":param"]
            NODE --> |FIsRouterRegex| REGEX["(pattern)"]
            NODE --> |FMiddleware| MWS[Middleware List]
            NODE --> |FCallback| CBS[Callback Dict]
            NODE --> |FRoute| CHILDREN[Child Routes]
        end
    end
```

## プロバイダー切り替え図

```mermaid
graph TB
    subgraph "Compile-time Selection"
        DEFINE{Compiler Define}

        DEFINE -->|HORSE_ISAPI| ISAPI[ISAPI Provider]
        DEFINE -->|HORSE_APACHE| APACHE[Apache Provider]
        DEFINE -->|HORSE_CGI| CGI[CGI Provider]
        DEFINE -->|HORSE_FCGI| FCGI[FastCGI Provider]
        DEFINE -->|HORSE_DAEMON| DAEMON[Daemon Provider]
        DEFINE -->|HORSE_VCL| VCL[VCL Provider]
        DEFINE -->|HORSE_LCL| LCL[LCL Provider]
        DEFINE -->|Default| CONSOLE[Console Provider]
    end

    subgraph "Provider Inheritance"
        ABS[THorseProviderAbstract]

        ABS --> |Delphi| INDY_PROVIDERS[Indy-based Providers]
        ABS --> |FPC| FPC_PROVIDERS[fpWeb-based Providers]

        INDY_PROVIDERS --> CONSOLE_D[Console]
        INDY_PROVIDERS --> VCL_D[VCL]
        INDY_PROVIDERS --> ISAPI_D[ISAPI]
        INDY_PROVIDERS --> APACHE_D[Apache]

        FPC_PROVIDERS --> CONSOLE_F[Console]
        FPC_PROVIDERS --> CGI_F[CGI]
        FPC_PROVIDERS --> FCGI_F[FastCGI]
        FPC_PROVIDERS --> LCL_F[LCL]
    end
```

## クラス図

```mermaid
classDiagram
    class THorse {
        +Listen()
        +Listen(port)
        +StopListen()
        +Get(path, callback)
        +Post(path, callback)
        +Put(path, callback)
        +Delete(path, callback)
        +Patch(path, callback)
        +Use(middleware)
        +Group()
        +Route(path)
    }

    class THorseCore {
        -FRoutes: THorseRouterTree
        -FCallbacks: TList~THorseCallback~
        -FDefaultHorse: THorseCore
        +GetInstance() THorseCore
        +RegisterRoute(type, path, callback)
        +AddCallback(callback)
        +Routes: THorseRouterTree
    }

    class THorseProviderAbstract {
        -FOnListen: TProc
        -FOnStopListen: TProc
        +Listen()
        +StopListen()
        +OnListen: TProc
        +OnStopListen: TProc
    }

    class THorseRouterTree {
        -FMiddleware: TList~THorseCallback~
        -FCallback: TObjectDictionary
        -FRoute: TObjectDictionary
        +RegisterRoute(type, path, callback)
        +RegisterMiddleware(middleware)
        +Execute(request, response)
    }

    class THorseRequest {
        -FWebRequest: TWebRequest
        -FHeaders: THorseCoreParam
        -FQuery: THorseCoreParam
        -FParams: THorseCoreParam
        +Body() string
        +Headers() THorseCoreParam
        +Query() THorseCoreParam
        +Params() THorseCoreParam
        +Session~T~() T
    }

    class THorseResponse {
        -FWebResponse: TWebResponse
        -FContent: TObject
        +Send(content) THorseResponse
        +Status(status) THorseResponse
        +SendFile(filename) THorseResponse
        +Download(filename) THorseResponse
        +RedirectTo(location) THorseResponse
    }

    class TNextCaller {
        -FIndex: Integer
        -FPath: TQueue~string~
        -FMiddleware: TList~THorseCallback~
        +Init() TNextCaller
        +Next()
        +SetCallback()
        +SetMiddleware()
    }

    class EHorseException {
        -FError: string
        -FStatus: THTTPStatus
        -FCode: Integer
        +Error(value) EHorseException
        +Status(value) EHorseException
        +ToJSON() string
    }

    THorse --|> THorseProviderAbstract
    THorseProviderAbstract --|> THorseCore
    THorseCore --> THorseRouterTree
    THorseRouterTree --> TNextCaller
    THorseRouterTree --> THorseRequest
    THorseRouterTree --> THorseResponse
    TNextCaller --> EHorseException
```
