# アーキテクチャ設計書

## 概要

本ドキュメントは、HorseフレームワークのアプリケーションアーキテクチャについてFOOD記述するものである。Horseは、Delphi/Lazarus向けのExpress.js風Webフレームワークであり、最小限のコードで高性能なWebアプリケーションを構築することを目的としている。

## システム全体構成

### アーキテクチャ概要図

詳細は [アーキテクチャ構成図.md](./アーキテクチャ構成図.md) を参照。

### システム境界と外部連携

| 外部システム | 連携方式 | 用途 |
| --- | --- | --- |
| HTTPクライアント | HTTP/HTTPS | Webリクエストの受信・レスポンス送信 |
| OpenSSL | ネイティブライブラリ | SSL/TLS通信の暗号化処理 |
| Indy (TIdHTTPWebBrokerBridge) | ネイティブライブラリ | HTTPサーバー機能の提供（Delphi） |
| fpWeb/fpHTTP | ネイティブライブラリ | HTTPサーバー機能の提供（Free Pascal/Lazarus） |

## レイヤー構成

### アーキテクチャスタイル

**ミドルウェアパイプライン型アーキテクチャ（Express.jsスタイル）**

Horseは、Express.jsにインスパイアされたミドルウェアベースのアーキテクチャを採用している。リクエストは登録されたミドルウェアを順番に通過し、最終的にルートハンドラーで処理される。このアーキテクチャは以下の特徴を持つ：

- ミドルウェアチェーンによるリクエスト/レスポンス処理
- コールバック関数を使用したルーティング
- シングルトンパターンによるフレームワークコア管理
- プロバイダーパターンによるマルチプラットフォーム対応

### レイヤー定義

| レイヤー | 責務 | 主なコンポーネント |
| --- | --- | --- |
| API/Facade | アプリケーションへの統一インターフェース提供 | `THorse`, `Horse.pas` |
| Core | ルーティング、コールバック管理、コア機能 | `THorseCore`, `THorseRouterTree`, `THorseCallback` |
| Provider | プラットフォーム固有のHTTPサーバー実装 | `THorseProvider*`（Console, VCL, CGI, Apache等） |
| Request/Response | HTTP要求/応答の抽象化 | `THorseRequest`, `THorseResponse` |
| Commons | 共通型定義、ヘルパー | `Horse.Commons`, `Horse.Mime`, `Horse.Exception` |

### レイヤー間の依存関係ルール

```
[Application Layer]
       ↓
[THorse (Facade)]
       ↓
[THorseCore] ← [THorseRouterTree] ← [TNextCaller]
       ↓
[THorseProviderAbstract]
       ↓
[Platform-specific Provider (Console/VCL/CGI/Apache/ISAPI/Daemon)]
       ↓
[THorseWebModule]
       ↓
[THorseRequest/THorseResponse]
```

**依存ルール：**
- 上位レイヤーは下位レイヤーに依存可能
- 下位レイヤーから上位レイヤーへの依存は禁止
- プロバイダー層は条件付きコンパイルにより必要なもののみ含まれる
- `Horse.pas`が全ての必要なユニットを集約し、アプリケーションは`uses Horse;`のみで利用可能

## モジュール構成

### ドメイン分割

| ドメイン | 責務 | 関連モジュール |
| --- | --- | --- |
| Routing | URLパスマッチング、HTTPメソッドディスパッチ | `Horse.Core.RouterTree`, `Horse.Core.Route`, `Horse.Core.Group` |
| Provider | プラットフォーム固有のHTTPサーバー管理 | `Horse.Provider.*` |
| Request Processing | リクエストパラメータ解析、ボディ処理 | `Horse.Request`, `Horse.Core.Param`, `Horse.Core.Param.*` |
| Response Processing | レスポンス生成、ファイル送信 | `Horse.Response`, `Horse.Core.Files` |
| Session | セッション管理 | `Horse.Session` |
| Exception | エラーハンドリング | `Horse.Exception`, `Horse.Exception.Interrupted` |

### パッケージ構造

```
src/
├── Horse.pas                           # メインファサードユニット
├── Horse.Core.pas                      # コアフレームワーク
├── Horse.Core.RouterTree.pas           # ルーティングツリー
├── Horse.Core.RouterTree.NextCaller.pas # ミドルウェアチェーン実行
├── Horse.Core.Route.pas                # ルート定義
├── Horse.Core.Route.Contract.pas       # ルートインターフェース
├── Horse.Core.Group.pas                # ルートグルーピング
├── Horse.Core.Group.Contract.pas       # グループインターフェース
├── Horse.Core.Param.pas                # パラメータ処理
├── Horse.Core.Param.Field.pas          # パラメータフィールド
├── Horse.Core.Param.Field.Brackets.pas # LHSブラケット解析
├── Horse.Core.Param.Header.pas         # ヘッダーパラメータ
├── Horse.Core.Param.Config.pas         # パラメータ設定
├── Horse.Core.Files.pas                # ファイル処理
├── Horse.Request.pas                   # リクエスト抽象化
├── Horse.Response.pas                  # レスポンス抽象化
├── Horse.Callback.pas                  # コールバック型定義
├── Horse.Proc.pas                      # プロシージャ型定義
├── Horse.Session.pas                   # セッション管理
├── Horse.Commons.pas                   # 共通型・ヘルパー
├── Horse.Mime.pas                      # MIMEタイプ処理
├── Horse.Exception.pas                 # 例外クラス
├── Horse.Exception.Interrupted.pas     # コールバック中断例外
├── Horse.Constants.pas                 # 定数定義
├── Horse.WebModule.pas                 # Webモジュール
├── Horse.WebModule.dfm                 # フォームファイル（Delphi）
├── Horse.WebModule.lfm                 # フォームファイル（Lazarus）
├── Horse.Rtti.Helper.pas               # RTTI補助
├── Horse.EnvironmentVariables.pas      # 環境変数
├── Horse.Provider.Abstract.pas         # プロバイダー抽象基底
├── Horse.Provider.Console.pas          # コンソールアプリ用
├── Horse.Provider.VCL.pas              # VCLアプリ用
├── Horse.Provider.CGI.pas              # CGI用
├── Horse.Provider.ISAPI.pas            # ISAPI用
├── Horse.Provider.Apache.pas           # Apacheモジュール用
├── Horse.Provider.Daemon.pas           # デーモン用
├── Horse.Provider.IOHandleSSL.pas      # SSL設定
├── Horse.Provider.IOHandleSSL.Contract.pas # SSLインターフェース
├── Horse.Provider.FPC.HTTPApplication.pas # FPC HTTPアプリケーション
├── Horse.Provider.FPC.CGI.pas          # FPC CGI用
├── Horse.Provider.FPC.FastCGI.pas      # FPC FastCGI用
├── Horse.Provider.FPC.Apache.pas       # FPC Apache用
├── Horse.Provider.FPC.Daemon.pas       # FPC デーモン用
├── Horse.Provider.FPC.LCL.pas          # FPC LCL用
└── ThirdParty.Posix.Syslog.pas         # サードパーティ：Syslog
```

### コンポーネント依存関係

**主要コンポーネント間の依存関係：**

1. **THorse** → THorseProvider（条件付きコンパイルで選択）
2. **THorseProvider** → THorseProviderAbstract → THorseCore
3. **THorseCore** → THorseRouterTree, THorseCallback
4. **THorseRouterTree** → THorseRequest, THorseResponse, TNextCaller
5. **TNextCaller** → THorseCallback, THorseException
6. **THorseRequest** → THorseCoreParam, THorseSessions
7. **THorseResponse** → THorseCoreFile, THorseMimeTypes

## ミドルウェア構成

### データベース

| 種類 | ミドルウェア | バージョン | 用途 |
| --- | --- | --- | --- |
| N/A | N/A | N/A | フレームワーク自体はデータベース機能を含まない |

*注：Horseはデータベース機能を含まない純粋なHTTPフレームワークである。データベースアクセスはアプリケーション側で実装する。*

### キャッシュ

| ミドルウェア | バージョン | 用途 | TTL |
| --- | --- | --- | --- |
| N/A | N/A | N/A | N/A |

*注：キャッシュ機能は含まれていない。必要に応じてミドルウェアとして追加実装可能。*

### メッセージキュー

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| N/A | N/A | N/A |

*注：メッセージキュー機能は含まれていない。*

### 検索エンジン

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| N/A | N/A | N/A |

*注：検索エンジン機能は含まれていない。*

### その他ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| Indy (TIdHTTPWebBrokerBridge) | 同梱 | HTTPサーバー機能（Delphi） |
| OpenSSL | 外部 | SSL/TLS暗号化 |
| fpWeb/fpHTTP | 同梱 | HTTPサーバー機能（Free Pascal） |

## データフロー

### リクエスト処理の流れ

HTTPリクエストの同期処理フロー：

1. **HTTPサーバー受信**: `TIdHTTPWebBrokerBridge`または`fpWeb`がHTTPリクエストを受信
2. **WebModule起動**: `THorseWebModule.HandlerAction`が呼び出される
3. **Request/Response生成**: `THorseRequest`と`THorseResponse`オブジェクトを生成
4. **ルーティング実行**: `THorseRouterTree.Execute`でパスマッチングを開始
5. **パス分割**: リクエストパスをキューに分割（`GetQueuePath`）
6. **ルート探索**: ツリー構造を辿りながら該当ルートを検索
7. **ミドルウェア実行**: `TNextCaller.Next`でミドルウェアチェーンを順次実行
8. **コールバック実行**: 最終的なルートハンドラー（コールバック）を実行
9. **レスポンス返却**: `THorseResponse`を通じてHTTPレスポンスを送信
10. **クリーンアップ**: Request/Responseオブジェクトを解放

### 非同期処理の流れ

Horseは同期処理を基本としており、非同期処理は以下の形で実現される：

1. **バックグラウンドスレッド**: アプリケーション側でTThreadを使用して非同期処理を実装
2. **イベント待機**: コンソールプロバイダーではTEventを使用してサーバー終了を待機
3. **コールバック中断**: `EHorseCallbackInterrupted`例外でミドルウェアチェーンを中断可能

### データ永続化の流れ

フレームワーク自体はデータ永続化機能を持たない。アプリケーション側でコールバック内に実装する。

## 横断的関心事

### 認証・認可

| 方式 | 実装箇所 | 対象 |
| --- | --- | --- |
| Basic認証 | `OnParseAuthentication`イベント | HTTPレベル認証 |
| JWT/Bearer | 公式ミドルウェア (horse-jwt, horse-bearer-auth) | アプリケーション認証 |
| カスタム認証 | ミドルウェアとして実装 | アプリケーション固有 |

*注：Horseコア自体は認証機能を持たず、ミドルウェアとして追加する設計である。*

### ロギング・監査

| 種類 | 実装方式 | 保存先 |
| --- | --- | --- |
| アプリケーションログ | 公式ミドルウェア (horse-logger) | 設定による |
| 監査ログ | カスタムミドルウェア | アプリケーション定義 |
| アクセスログ | カスタムミドルウェア | アプリケーション定義 |

### エラーハンドリング

エラーハンドリングの方針：

| エラー種別 | ハンドリング方式 | レスポンス |
| --- | --- | --- |
| ルート未検出 | `TNextCaller.Next`内で自動処理 | 404 Not Found |
| メソッド不一致 | `TNextCaller.Next`内で自動処理 | 405 Method Not Allowed |
| アプリケーション例外 | `EHorseException`で明示的にスロー | カスタムステータス/JSON |
| コールバック中断 | `EHorseCallbackInterrupted`でチェーン中断 | 現在のレスポンス状態を維持 |
| 未ハンドル例外 | `TNextCaller.Next`内でキャッチ | 500 Internal Server Error |

### トランザクション管理

| 範囲 | 管理方式 | 分離レベル |
| --- | --- | --- |
| N/A | N/A | N/A |

*注：トランザクション管理はフレームワークに含まれない。アプリケーション側でデータベース接続と共に実装する。*

## 設計原則・コーディング規約

### 適用している設計原則

| 原則 | 適用箇所 | 実装例 |
| --- | --- | --- |
| シングルトンパターン | `THorseCore.GetInstance` | グローバルなフレームワークインスタンス管理 |
| ファサードパターン | `THorse`クラス | アプリケーションへの単純化されたインターフェース |
| ストラテジーパターン | `THorseProvider*` | プラットフォーム固有の実装を切り替え |
| Fluent Interface | `THorseRequest`, `THorseResponse`, `EHorseException` | メソッドチェーン可能なAPI |
| ジェネリクス | `IHorseCoreGroup<T>`, `IHorseCoreRoute<T>` | 型安全なグループ/ルートビルダー |
| 条件付きコンパイル | 全ユニット | Delphi/FPCの両対応 |

### コーディング規約

**命名規則：**
- クラス名: `T`プレフィックス（例: `THorseCore`）
- インターフェース名: `I`プレフィックス（例: `IHorseCoreRoute`）
- 例外クラス: `E`プレフィックス（例: `EHorseException`）
- ユニット名: `Horse.`で始まるドット区切り階層構造

**Delphi/FPC互換性：**
- `{$IF DEFINED(FPC)}`による条件付きコンパイル
- 両プラットフォームでの動作を保証
- プラットフォーム固有の型は条件付きで定義

**メモリ管理：**
- 所有権を明確にしたオブジェクト管理
- `FreeAndNil`による安全な解放
- `TObjectDictionary`の`doOwnsValues`によるコンテナ管理

## 備考

### 対応プラットフォーム

- **Delphi**: 13 Florence, 12 Athens, 11 Alexandria, 10.4 Sydney, 10.3 Rio, 10.2 Tokyo, 10.1 Berlin, 10 Seattle, XE8, XE7
- **Lazarus/Free Pascal**: LCL, Console, Daemon, CGI, FastCGI, Apache

### 公式ミドルウェア

以下のミドルウェアは公式に提供されている：
- horse/json (jhonson)
- horse/basic-auth
- horse/cors
- horse/stream (octet-stream)
- horse/jwt
- horse/exception (handle-exception)
- horse/logger
- horse/compression

### ライセンス

MIT License
