---
generated_at: 2026-01-22 00:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 28
  claims_without_evidence: 7
confidence_derived: 0.80
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.80**
  - 根拠あり：28 / 35、根拠なし：7
- 優先レビュー（高）
  1. **スケーリング具体値**：MaxConnections、ListenQueueの推奨値に関する根拠不足
  2. **バックアップ設計**：プロジェクトに具体的なバックアップ設定ファイルがないため推奨事項として記載
  3. **監視設計**：具体的な監視ツール設定ファイルがプロジェクトに含まれていない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.pas` - メインユニット、プロバイダー定義
- E-02: `src/Horse.Constants.pas` - デフォルト定数定義（ホスト、ポート、バージョン）
- E-03: `src/Horse.Provider.Console.pas` - Consoleプロバイダー実装
- E-04: `src/Horse.Provider.VCL.pas` - VCLプロバイダー実装
- E-05: `src/Horse.Provider.CGI.pas` - CGIプロバイダー実装
- E-06: `src/Horse.Provider.Abstract.pas` - 抽象プロバイダー基底クラス
- E-07: `src/Horse.Provider.IOHandleSSL.Contract.pas` - SSL/TLSインターフェース定義
- E-08: `samples/delphi/apache/Apache.dpr` - Apacheモジュールサンプル
- E-09: `samples/delphi/isapi/ISAPI.dpr` - ISAPIサンプル
- E-10: `samples/delphi/winsvc/src/Main.Service.pas` - Windowsサービスサンプル
- E-11: `samples/delphi/daemon/Daemon.dpr` - デーモンサンプル
- E-12: `samples/lazarus/daemon/daemon.lpr` - Lazarusデーモンサンプル
- E-13: `.github/workflows/tests.yml` - CI/CDワークフロー定義
- E-14: `README.md` - プロジェクト概要、対応Delphiバージョン、ミドルウェア一覧
- E-15: `boss.json` - パッケージ定義
- E-16: `src/Horse.EnvironmentVariables.pas` - 環境変数取得機能
- E-17: `src/ThirdParty.Posix.Syslog.pas` - Syslog対応

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトホストは0.0.0.0 | E-02 | ○ |
| C-02 | デフォルトポートは9000 | E-02 | ○ |
| C-03 | フレームワークバージョンは3.1.9 | E-02 | ○ |
| C-04 | Consoleプロバイダーをサポート | E-01, E-03 | ○ |
| C-05 | VCLプロバイダーをサポート | E-01, E-04 | ○ |
| C-06 | CGIプロバイダーをサポート | E-01, E-05 | ○ |
| C-07 | ISAPIプロバイダーをサポート | E-01, E-09 | ○ |
| C-08 | Apacheモジュールをサポート | E-01, E-08 | ○ |
| C-09 | Daemonプロバイダーをサポート | E-01, E-11, E-12 | ○ |
| C-10 | LCLプロバイダーをサポート | E-01 | ○ |
| C-11 | Indy HTTPサーバーを使用 | E-03, E-04 | ○ |
| C-12 | SSL/TLS対応（OpenSSL経由） | E-07, E-03, E-04 | ○ |
| C-13 | MaxConnections設定が可能 | E-03, E-04 | ○ |
| C-14 | ListenQueue設定が可能 | E-03, E-04 | ○ |
| C-15 | KeepConnectionAliveのデフォルトはTrue | E-03, E-04 | ○ |
| C-16 | Windowsサービスとして動作可能 | E-10 | ○ |
| C-17 | GitHub Actionsでテスト実行 | E-13 | ○ |
| C-18 | windows-latestランナーを使用 | E-13 | ○ |
| C-19 | Bossパッケージマネージャー対応 | E-14, E-15 | ○ |
| C-20 | 公式ミドルウェア8種類 | E-14 | ○ |
| C-21 | Delphi XE7からDelphi 13まで対応 | E-14 | ○ |
| C-22 | MITライセンス | E-14 | ○ |
| C-23 | 環境変数取得機能あり | E-16 | ○ |
| C-24 | Syslog対応（POSIX） | E-17 | ○ |
| C-25 | Apache httpd.conf設定例 | E-08 | ○ |
| C-26 | SSL証明書ファイル設定 | E-07 | ○ |
| C-27 | DHパラメータファイル設定 | E-07 | ○ |
| C-28 | 暗号スイート設定 | E-07 | ○ |
| C-29 | MaxConnectionsの推奨値100 | **根拠なし** | △ |
| C-30 | バックアップ世代数の推奨（3-5世代） | **根拠なし** | △ |
| C-31 | ログローテーション日次推奨 | **根拠なし** | △ |
| C-32 | 監視閾値の具体値 | **根拠なし** | △ |
| C-33 | ロードバランサー構成の詳細 | **根拠なし** | △ |
| C-34 | systemdによるプロセス管理 | **根拠なし** | △ |
| C-35 | Kubernetes/Docker Swarm対応 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **インフラ構成ファイル不在**: 本プロジェクトにはDockerfile、docker-compose.yml、Kubernetesマニフェスト、Terraform/CloudFormationファイルが含まれていない
  - 候補：Dockerfile / docker-compose.yml / kubernetes/deployment.yaml
- **監視設定ファイル不在**: 具体的な監視設定（Prometheus、Grafana等）が含まれていない
  - 候補：prometheus.yml / alertmanager.yml / grafana/dashboards
- **ログ設定ファイル不在**: 具体的なログローテーション設定が含まれていない
  - 候補：logrotate.conf / filebeat.yml
- **推奨値の根拠**: スケーリングやバックアップの推奨値は一般的なベストプラクティスに基づくが、本プロジェクト固有の設定ファイルからは確認できない

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: デフォルト設定値（ホスト、ポート、バージョン）- ソースコードから直接確認可能
- **0（低リスク）**: プロバイダー種別 - コンパイルディレクティブとソースコードで確認可能
- **1（中リスク）**: SSL/TLS設定 - インターフェース定義は確認済みだが、実際の証明書管理は運用環境依存
- **1（中リスク）**: スケーリング設定 - パラメータの存在は確認済みだが、推奨値は一般的なガイドライン
- **2（高リスク）**: バックアップ・監視設計 - プロジェクト固有の設定がないため、一般的な推奨事項として記載

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルトポート9000が運用環境で適切か確認
- [ ] SSL/TLS証明書の管理方法が運用ポリシーに合致するか確認
- [ ] MaxConnections、ListenQueueの値が想定トラフィックに適切か確認
- [ ] バックアップ頻度・保持期間が事業要件を満たすか確認
- [ ] 監視閾値が運用SLAに適合するか確認
- [ ] Windowsサービス/Linuxデーモンの自動起動設定が適切か確認
- [ ] ロードバランサー構成が可用性要件を満たすか確認
