# インフラ構成図

## 概要

本ドキュメントは、Horse Webフレームワークの各デプロイメントパターンにおけるインフラ構成図をmermaid形式で記載します。

## 全体アーキテクチャ

```mermaid
graph TB
    subgraph "Horse Framework"
        CORE[Horse.Core<br/>コアルーティングエンジン]

        subgraph "Providers"
            CONSOLE[Console Provider<br/>スタンドアロンHTTP]
            VCL[VCL Provider<br/>Windows GUI]
            CGI[CGI Provider<br/>CGI連携]
            ISAPI[ISAPI Provider<br/>IIS連携]
            APACHE[Apache Provider<br/>Apacheモジュール]
            DAEMON[Daemon Provider<br/>バックグラウンド]
            LCL[LCL Provider<br/>Lazarus GUI]
        end

        INDY[Indy HTTP Server<br/>TIdHTTPWebBrokerBridge]
        SSL[OpenSSL Handler<br/>SSL/TLS]
    end

    CORE --> CONSOLE
    CORE --> VCL
    CORE --> CGI
    CORE --> ISAPI
    CORE --> APACHE
    CORE --> DAEMON
    CORE --> LCL

    CONSOLE --> INDY
    VCL --> INDY
    DAEMON --> INDY
    INDY --> SSL
```

## デプロイメントパターン

### パターン1: スタンドアロン構成（Console/VCL）

```mermaid
graph LR
    subgraph "Client"
        BROWSER[Web Browser<br/>HTTP Client]
    end

    subgraph "Application Server"
        HORSE[Horse Application<br/>Console/VCL]
        INDY[Indy HTTP Server<br/>Port: 9000]
        SSL[OpenSSL<br/>HTTPS対応]
    end

    BROWSER -->|HTTP/HTTPS| INDY
    INDY --> HORSE
    INDY -.-> SSL
```

### パターン2: リバースプロキシ構成

```mermaid
graph LR
    subgraph "Client"
        BROWSER[Web Browser]
    end

    subgraph "Web Server"
        NGINX[nginx/Apache<br/>Port: 80/443]
        LB[Load Balancer]
    end

    subgraph "Application Servers"
        HORSE1[Horse Instance 1<br/>Port: 9000]
        HORSE2[Horse Instance 2<br/>Port: 9001]
        HORSE3[Horse Instance N<br/>Port: 900N]
    end

    BROWSER -->|HTTPS| NGINX
    NGINX --> LB
    LB --> HORSE1
    LB --> HORSE2
    LB --> HORSE3
```

### パターン3: Apache モジュール構成

```mermaid
graph LR
    subgraph "Client"
        BROWSER[Web Browser]
    end

    subgraph "Apache HTTP Server"
        HTTPD[Apache httpd<br/>Port: 80/443]
        HANDLER[apache_horse_module<br/>SetHandler]
        HORSE[Horse Application<br/>DLL/SO]
    end

    BROWSER -->|HTTP/HTTPS| HTTPD
    HTTPD --> HANDLER
    HANDLER --> HORSE
```

### パターン4: IIS + ISAPI 構成

```mermaid
graph LR
    subgraph "Client"
        BROWSER[Web Browser]
    end

    subgraph "Windows Server"
        IIS[IIS<br/>Port: 80/443]
        ISAPI[ISAPI Extension<br/>DLL]
        HORSE[Horse Application]
    end

    BROWSER -->|HTTP/HTTPS| IIS
    IIS --> ISAPI
    ISAPI --> HORSE
```

### パターン5: CGI/FastCGI 構成

```mermaid
graph LR
    subgraph "Client"
        BROWSER[Web Browser]
    end

    subgraph "Web Server"
        WEBSVR[Apache/nginx<br/>Port: 80/443]
        CGI[CGI/FastCGI<br/>Gateway]
    end

    subgraph "Application"
        HORSE[Horse CGI Application<br/>実行ファイル]
    end

    BROWSER -->|HTTP/HTTPS| WEBSVR
    WEBSVR --> CGI
    CGI -->|プロセス起動| HORSE
```

### パターン6: Windows サービス構成

```mermaid
graph TB
    subgraph "Client"
        BROWSER[Web Browser]
    end

    subgraph "Windows Server"
        SCM[Service Control Manager]
        SERVICE[Horse Windows Service<br/>TService]
        INDY[Indy HTTP Server<br/>Port: 9000]
    end

    SCM -->|Start/Stop| SERVICE
    SERVICE --> INDY
    BROWSER -->|HTTP| INDY
```

### パターン7: Linux Daemon 構成

```mermaid
graph TB
    subgraph "Client"
        BROWSER[Web Browser]
    end

    subgraph "Linux Server"
        SYSTEMD[systemd]
        DAEMON[Horse Daemon Process]
        HTTP[HTTP Server<br/>Port: 9000]
    end

    SYSTEMD -->|Start/Stop/Restart| DAEMON
    DAEMON --> HTTP
    BROWSER -->|HTTP| HTTP
```

## SSL/TLS 構成

```mermaid
graph TB
    subgraph "SSL Configuration"
        SSL[IHorseProviderIOHandleSSL]
        CERT[Certificate File<br/>server.crt]
        KEY[Key File<br/>server.key]
        ROOT[Root CA File<br/>ca.crt]
        DH[DH Params File<br/>dhparam.pem]
        CIPHER[Cipher List]
        VERSION[SSL Versions<br/>TLS 1.2/1.3]
    end

    subgraph "OpenSSL"
        OPENSSL[TIdServerIOHandlerSSLOpenSSL]
    end

    SSL --> CERT
    SSL --> KEY
    SSL --> ROOT
    SSL --> DH
    SSL --> CIPHER
    SSL --> VERSION
    SSL --> OPENSSL
```

## ミドルウェアスタック

```mermaid
graph TB
    subgraph "Request Flow"
        REQ[HTTP Request]
    end

    subgraph "Middleware Stack"
        MW1[horse/logger<br/>ロギング]
        MW2[horse/cors<br/>CORS処理]
        MW3[horse/compression<br/>圧縮]
        MW4[horse/jwt<br/>認証]
        MW5[horse/json<br/>JSON処理]
        MW6[horse/exception<br/>例外処理]
    end

    subgraph "Application"
        ROUTE[Route Handler]
    end

    subgraph "Response Flow"
        RES[HTTP Response]
    end

    REQ --> MW1
    MW1 --> MW2
    MW2 --> MW3
    MW3 --> MW4
    MW4 --> MW5
    MW5 --> ROUTE
    ROUTE --> MW6
    MW6 --> RES
```

## CI/CD パイプライン

```mermaid
graph LR
    subgraph "Source Control"
        GIT[GitHub Repository]
    end

    subgraph "CI Pipeline"
        TRIGGER[Push/PR Trigger]
        CHECKOUT[Checkout Code]
        BUILD[Build Tests]
        TEST_CONSOLE[Console Tests]
        TEST_VCL[VCL Tests]
    end

    subgraph "Artifacts"
        EXE[Executable]
        DLL[DLL/SO]
    end

    GIT --> TRIGGER
    TRIGGER --> CHECKOUT
    CHECKOUT --> BUILD
    BUILD --> TEST_CONSOLE
    BUILD --> TEST_VCL
    TEST_CONSOLE --> EXE
    TEST_VCL --> DLL
```

## 接続設定パラメータ

```mermaid
graph TB
    subgraph "Configuration"
        HOST[Host<br/>Default: 0.0.0.0]
        PORT[Port<br/>Default: 9000]
        MAXCONN[MaxConnections]
        QUEUE[ListenQueue]
        KEEPALIVE[KeepConnectionAlive<br/>Default: True]
    end

    subgraph "HTTP Server"
        INDY[TIdHTTPWebBrokerBridge]
    end

    HOST --> INDY
    PORT --> INDY
    MAXCONN --> INDY
    QUEUE --> INDY
    KEEPALIVE --> INDY
```

## 高可用性構成

```mermaid
graph TB
    subgraph "Internet"
        CLIENT[Clients]
    end

    subgraph "Load Balancer Layer"
        LB[Load Balancer<br/>nginx/HAProxy]
    end

    subgraph "Application Layer"
        APP1[Horse Instance 1]
        APP2[Horse Instance 2]
        APPN[Horse Instance N]
    end

    subgraph "Data Layer"
        DB[(Database)]
        CACHE[(Cache)]
    end

    subgraph "Monitoring"
        HEALTH[Health Check<br/>/health endpoint]
        METRICS[Prometheus Metrics]
        LOGS[Logging]
    end

    CLIENT --> LB
    LB --> APP1
    LB --> APP2
    LB --> APPN

    APP1 --> DB
    APP2 --> DB
    APPN --> DB

    APP1 --> CACHE
    APP2 --> CACHE
    APPN --> CACHE

    APP1 --> HEALTH
    APP2 --> HEALTH
    APPN --> HEALTH

    HEALTH --> METRICS
    APP1 --> LOGS
    APP2 --> LOGS
    APPN --> LOGS
```
